/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.buildinfo;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperations;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.traits.IAddableByTrait;
import com.helger.json.IJson;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.maven.buildinfo.JsonProps;
import com.helger.xml.microdom.util.XMLMapHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-buildinfo", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class GenerateBuildInfoMojo
extends AbstractMojo {
    private static final String DEFAULT_FILENAME_BUILDINFO_XML = "buildinfo.xml";
    private static final String DEFAULT_FILENAME_BUILDINFO_PROPERTIES = "buildinfo.properties";
    private static final String DEFAULT_FILENAME_BUILDINFO_JSON = "buildinfo.json";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="ignoredPackagings", defaultValue="pom")
    private HashSet<String> ignoredPackagings;
    @Parameter(property="tempDirectory", defaultValue="${project.build.directory}/buildinfo-maven-plugin", required=true)
    private File tempDirectory;
    @Parameter(property="timeZone")
    private String timeZone;
    @Parameter(property="withAllSystemProperties", defaultValue="false")
    private boolean withAllSystemProperties = false;
    @Parameter(property="selectedSystemProperties")
    private HashSet<String> selectedSystemProperties;
    @Parameter(property="ignoredSystemProperties")
    private HashSet<String> ignoredSystemProperties;
    @Parameter(property="withAllEnvVars", defaultValue="false")
    private boolean withAllEnvVars = false;
    @Parameter(property="selectedEnvVars")
    private HashSet<String> selectedEnvVars;
    @Parameter(property="ignoredEnvVars")
    private HashSet<String> ignoredEnvVars;
    @Parameter(property="formatXML", defaultValue="true")
    private boolean formatXML = true;
    @Parameter(property="formatProperties", defaultValue="false")
    private boolean formatProperties = false;
    @Parameter(property="formatJson", defaultValue="false")
    private boolean formatJson = false;
    @Parameter(property="targetPath", defaultValue="META-INF", required=true)
    private String targetPath;

    public void setIgnoredPackagings(Set<String> set) {
        this.ignoredPackagings = new HashSet();
        if (set != null) {
            for (String string : set) {
                if (!StringHelper.hasText((String)string) || this.ignoredPackagings.add(string)) continue;
                this.getLog().warn((CharSequence)("The ignored packaging '" + string + "' is contained more than once"));
            }
        }
    }

    public void setTempDirectory(@Nonnull File file) throws MojoExecutionException {
        if (file == null) {
            throw new MojoExecutionException("No buildinfo temp directory specified!");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new MojoExecutionException("The specified buildinfo temp directory " + file + " is not a directory!");
        }
        this.tempDirectory = file;
        if (!this.tempDirectory.isAbsolute()) {
            this.tempDirectory = new File(this.project.getBasedir(), file.getPath());
        }
    }

    public void setTimeZone(String string) {
        try {
            ZoneId zoneId = ZoneId.of(string);
            TimeZone timeZone = TimeZone.getTimeZone(zoneId);
            TimeZone.setDefault(timeZone);
            this.timeZone = string;
        }
        catch (DateTimeException dateTimeException) {
            this.getLog().warn((CharSequence)("Unknown time zone '" + string + "'"));
        }
    }

    public void setWithAllSystemProperties(boolean bl) {
        this.withAllSystemProperties = bl;
        if (this.withAllSystemProperties && this.selectedSystemProperties != null && !this.selectedSystemProperties.isEmpty()) {
            this.getLog().warn((CharSequence)"Clearing all selected system properties, because all system properties are enabled!");
            this.setSelectedSystemProperties(null);
        }
    }

    public void setSelectedSystemProperties(Set<String> set) {
        this.selectedSystemProperties = new HashSet();
        if (set != null) {
            for (String string : set) {
                if (!StringHelper.hasText((String)string) || this.selectedSystemProperties.add(string)) continue;
                this.getLog().warn((CharSequence)("The selected system property '" + string + "' is contained more than once"));
            }
        }
        if (!this.selectedSystemProperties.isEmpty() && this.withAllSystemProperties) {
            this.getLog().warn((CharSequence)"Disabling all system properties, because selected system properties are defined!");
            this.setWithAllSystemProperties(false);
        }
    }

    public void setIgnoredSystemProperties(Set<String> set) {
        this.ignoredSystemProperties = new HashSet();
        if (set != null) {
            for (String string : set) {
                if (!StringHelper.hasText((String)string) || this.ignoredSystemProperties.add(string)) continue;
                this.getLog().warn((CharSequence)("The ignored system property '" + string + "' is contained more than once"));
            }
        }
    }

    public void setWithAllEnvVars(boolean bl) {
        this.withAllEnvVars = bl;
        if (this.withAllEnvVars && this.selectedEnvVars != null && !this.selectedEnvVars.isEmpty()) {
            this.getLog().warn((CharSequence)"Clearing all environment variables, because all environment variables are enabled!");
            this.setSelectedEnvVars(null);
        }
    }

    public void setSelectedEnvVars(Set<String> set) {
        this.selectedEnvVars = new HashSet();
        if (set != null) {
            for (String string : set) {
                if (!StringHelper.hasText((String)string) || this.selectedEnvVars.add(string)) continue;
                this.getLog().warn((CharSequence)("The selected environment variable '" + string + "' is contained more than once"));
            }
        }
        if (!this.selectedEnvVars.isEmpty() && this.withAllEnvVars) {
            this.getLog().warn((CharSequence)"Disabling all environment variables, because selected environment variables are defined!");
            this.setWithAllEnvVars(false);
        }
    }

    public void setIgnoredEnvVars(Set<String> set) {
        this.ignoredEnvVars = new HashSet();
        if (set != null) {
            for (String string : set) {
                if (!StringHelper.hasText((String)string) || this.ignoredEnvVars.add(string)) continue;
                this.getLog().warn((CharSequence)("The ignored environment variable '" + string + "' is contained more than once"));
            }
        }
    }

    public void setFormatXML(boolean bl) {
        this.formatXML = bl;
    }

    public void setFormatProperties(boolean bl) {
        this.formatProperties = bl;
    }

    public void setFormatJson(boolean bl) {
        this.formatJson = bl;
    }

    public void setTargetPath(String string) throws MojoExecutionException {
        if (string == null) {
            throw new MojoExecutionException("targetPath may not be null");
        }
        this.targetPath = string;
    }

    private static boolean _matches(@Nullable Set<String> set, @Nonnull String string) {
        if (set == null) {
            return false;
        }
        if (set.contains(string)) {
            return true;
        }
        for (String string2 : set) {
            if (!RegExHelper.stringMatchesPattern((String)string2, (String)string)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private JsonProps _determineBuildInfoProperties() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        List list;
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
        JsonProps jsonProps = new JsonProps();
        jsonProps.getChild("buildinfo").add("version", "3");
        jsonProps.getChild("project").add("groupid", this.project.getGroupId());
        jsonProps.getChild("project").add("artifactid", this.project.getArtifactId());
        jsonProps.getChild("project").add("version", this.project.getVersion());
        jsonProps.getChild("project").add("name", this.project.getName());
        jsonProps.getChild("project").add("packaging", this.project.getPackaging());
        MavenProject mavenProject = this.project.getParent();
        if (mavenProject != null) {
            jsonProps.getChild("parentproject").add("groupid", mavenProject.getGroupId());
            jsonProps.getChild("parentproject").add("artifactid", mavenProject.getArtifactId());
            jsonProps.getChild("parentproject").add("version", mavenProject.getVersion());
            jsonProps.getChild("parentproject").add("name", mavenProject.getName());
        }
        if (this.reactorProjects != null && this.reactorProjects.size() != 1) {
            list = new JsonArray();
            object6 = this.reactorProjects.iterator();
            while (object6.hasNext()) {
                object5 = (MavenProject)object6.next();
                object4 = new JsonProps();
                object4.add("groupid", (Object)object5.getGroupId());
                object4.add("artifactid", (Object)object5.getArtifactId());
                object4.add("version", (Object)object5.getVersion());
                object4.add("name", (Object)object5.getName());
                list.add((IAddableByTrait)object4);
            }
            jsonProps.addJson("reactorproject", (IJson)list);
        }
        if ((list = this.project.getBuildPlugins()) != null) {
            object6 = new JsonArray();
            object5 = list.iterator();
            while (object5.hasNext()) {
                object4 = (Plugin)object5.next();
                object3 = new JsonProps();
                object3.add("groupid", (Object)object4.getGroupId());
                object3.add("artifactid", (Object)object4.getArtifactId());
                object3.add("version", (Object)object4.getVersion());
                object2 = object4.getConfiguration();
                if (object2 != null) {
                    object3.add("configuration", (Object)object2.toString());
                }
                object3.add("key", (Object)object4.getKey());
                object6.add((IAddableByTrait)object3);
            }
            jsonProps.getChild("build").addJson("plugin", (IJson)object6);
        }
        if ((object6 = this.project.getDependencies()) != null) {
            object5 = new JsonArray();
            object4 = object6.iterator();
            while (object4.hasNext()) {
                object3 = (Dependency)object4.next();
                object2 = new JsonProps();
                object2.add("groupid", (Object)object3.getGroupId());
                object2.add("artifactid", (Object)object3.getArtifactId());
                object2.add("version", (Object)object3.getVersion());
                object2.add("type", (Object)object3.getType());
                if (object3.getClassifier() != null) {
                    object2.add("classifier", (Object)object3.getClassifier());
                }
                object2.add("scope", (Object)object3.getScope());
                if (object3.getSystemPath() != null) {
                    object2.add("systempath", (Object)object3.getSystemPath());
                }
                object2.add("optional", object3.isOptional());
                object2.add("managementkey", (Object)object3.getManagementKey());
                Iterator iterator = object3.getExclusions();
                if (iterator != null) {
                    Object object7 = new JsonArray();
                    object = iterator.iterator();
                    while (object.hasNext()) {
                        Exclusion exclusion = (Exclusion)object.next();
                        object7.add((IAddableByTrait)new JsonObject().add("groupid", (Object)exclusion.getGroupId()).add("artifactid", (Object)exclusion.getArtifactId()));
                    }
                    object2.addJson("exclusion", (IJson)object7);
                }
                object5.add((IAddableByTrait)object2);
            }
            jsonProps.addJson("dependency", (IJson)object5);
        }
        if ((object5 = this.project.getActiveProfiles()) != null) {
            object4 = new JsonArray();
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (Profile)object3.next();
                object4.add((IAddableByTrait)new JsonObject().add("id", (Object)object2.getId()));
            }
            jsonProps.addJson("profiles", (IJson)object4);
        }
        object4 = this.timeZone != null ? ZoneId.of(this.timeZone) : ZoneId.systemDefault();
        object3 = ZonedDateTime.of(localDateTime, (ZoneId)object4);
        int n = ((ZonedDateTime)object3).getOffset().getTotalSeconds();
        jsonProps.getChildren("build", "datetime").add("text", localDateTime.toString());
        jsonProps.getChildren("build", "datetime").add("millis", PDTFactory.getMillis((LocalDateTime)localDateTime));
        jsonProps.getChildren("build", "datetime").add("date", localDateTime.toLocalDate().toString());
        jsonProps.getChildren("build", "datetime").add("time", localDateTime.toLocalTime().toString());
        jsonProps.getChildren("build", "datetime", "timezone").add("id", ((ZoneId)object4).getId());
        jsonProps.getChildren("build", "datetime", "timezone").add("offsethours", n / 3600);
        jsonProps.getChildren("build", "datetime", "timezone").add("offsetmins", n / 60);
        jsonProps.getChildren("build", "datetime", "timezone").add("offsetsecs", n);
        jsonProps.getChildren("build", "datetime", "timezone").add("offsetmillisecs", (long)n * 1000L);
        if (this.withAllSystemProperties || CollectionHelper.isNotEmpty(this.selectedSystemProperties)) {
            for (Object object7 : CollectionHelper.getSortedByKey((Map)SystemProperties.getAllProperties()).entrySet()) {
                object = (String)object7.getKey();
                if (!this.withAllSystemProperties && !GenerateBuildInfoMojo._matches(this.selectedSystemProperties, (String)object) || GenerateBuildInfoMojo._matches(this.ignoredSystemProperties, (String)object)) continue;
                jsonProps.getChild("systemproperty").add((String)object, object7.getValue());
            }
        }
        if (this.withAllEnvVars || CollectionHelper.isNotEmpty(this.selectedEnvVars)) {
            for (Object object7 : CollectionHelper.getSortedByKey(System.getenv()).entrySet()) {
                object = (String)object7.getKey();
                if (!this.withAllEnvVars && !GenerateBuildInfoMojo._matches(this.selectedEnvVars, (String)object) || GenerateBuildInfoMojo._matches(this.ignoredEnvVars, (String)object)) continue;
                jsonProps.getChild("envvar").add((String)object, object7.getValue());
            }
        }
        return jsonProps;
    }

    private void _writeBuildinfoXMLv1(@Nonnull JsonProps jsonProps) throws MojoExecutionException {
        File file = new File(this.tempDirectory, DEFAULT_FILENAME_BUILDINFO_XML);
        if (XMLMapHandler.writeMap(jsonProps.getAsFlatList(), (IHasOutputStream)new FileSystemResource(file)).isFailure()) {
            throw new MojoExecutionException("Failed to write XML file to " + file);
        }
        this.getLog().debug((CharSequence)("Wrote buildinfo XML file to " + file));
    }

    private void _writeBuildinfoProperties(@Nonnull JsonProps jsonProps) throws MojoExecutionException {
        File file = new File(this.tempDirectory, DEFAULT_FILENAME_BUILDINFO_PROPERTIES);
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        nonBlockingProperties.putAll(jsonProps.getAsFlatList());
        try {
            nonBlockingProperties.store((OutputStream)FileHelper.getOutputStream((File)file), "Generated - do not edit!");
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to write properties file to " + file, (Exception)iOException);
        }
        this.getLog().debug((CharSequence)("Wrote buildinfo properties file to " + file));
    }

    private void _writeBuildinfoJson(@Nonnull JsonProps jsonProps) throws MojoExecutionException {
        File file = new File(this.tempDirectory, DEFAULT_FILENAME_BUILDINFO_JSON);
        try (NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)file, (EAppend)EAppend.TRUNCATE, (Charset)StandardCharsets.UTF_8);){
            new JsonWriter(JsonWriterSettings.DEFAULT_SETTINGS_FORMATTED).writeToWriter((IJson)jsonProps, (Writer)nonBlockingBufferedWriter);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to write JSON file to " + file, (Exception)iOException);
        }
        this.getLog().debug((CharSequence)("Wrote buildinfo JSON file to " + file));
    }

    public void execute() throws MojoExecutionException {
        if (this.ignoredPackagings != null && this.ignoredPackagings.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Not executing buildinfo plugin because the packaging '" + this.project.getPackaging() + "' is ignored."));
            return;
        }
        FileIOError fileIOError = FileOperations.createDirRecursiveIfNotExisting((File)this.tempDirectory);
        if (fileIOError.isFailure()) {
            this.getLog().error((CharSequence)("Failed to create temp directory " + this.tempDirectory.getName() + ": " + fileIOError.toString()));
        } else {
            this.getLog().info((CharSequence)("Successfully created temp directory " + this.tempDirectory.getName()));
        }
        if (!(this.formatXML || this.formatProperties || this.formatJson)) {
            throw new MojoExecutionException("No buildinfo output format was specified. Nothing will be generated!");
        }
        JsonProps jsonProps = this._determineBuildInfoProperties();
        if (this.formatXML) {
            this._writeBuildinfoXMLv1(jsonProps);
        }
        if (this.formatProperties) {
            this._writeBuildinfoProperties(jsonProps);
        }
        if (this.formatJson) {
            this._writeBuildinfoJson(jsonProps);
        }
        Resource resource = new Resource();
        resource.setDirectory(this.tempDirectory.getAbsolutePath());
        resource.addInclude("**/*");
        resource.setFiltering(false);
        resource.setTargetPath(this.targetPath);
        this.project.addResource(resource);
    }
}

