/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vehiclesigns;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.exception.InitializationException;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.text.locale.country.CountryCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Locale;

@Immutable
public final class VehicleSigns {
    private static final ICommonsMap<Locale, ICommonsOrderedSet<String>> COUNTRY_TO_SIGN = new CommonsHashMap();
    private static final ICommonsMap<String, ICommonsOrderedSet<Locale>> SIGN_TO_COUNTRY = new CommonsHashMap();

    private static void _add(@Nonnull String string2, @Nonnull String string3) {
        Locale locale2 = CountryCache.getInstance().getCountry(string2);
        if (!((ICommonsOrderedSet)COUNTRY_TO_SIGN.computeIfAbsent((Object)locale2, locale -> new CommonsLinkedHashSet())).add((Object)string3)) {
            throw new InitializationException("Locale " + String.valueOf(locale2) + " already contains sign '" + string3 + "'");
        }
        if (!((ICommonsOrderedSet)SIGN_TO_COUNTRY.computeIfAbsent((Object)string3, string -> new CommonsLinkedHashSet())).add((Object)locale2)) {
            throw new InitializationException("Sign '" + string3 + "' already contains country " + String.valueOf(locale2));
        }
    }

    private VehicleSigns() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<String> getAllVehicleSigns(@Nullable String string) {
        Locale locale = CountryCache.getInstance().getCountry(string);
        ICommonsOrderedSet iCommonsOrderedSet = (ICommonsOrderedSet)COUNTRY_TO_SIGN.get((Object)locale);
        return new CommonsLinkedHashSet((Collection)iCommonsOrderedSet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<String> getAllVehicleSigns(@Nullable Locale locale) {
        return VehicleSigns.getAllVehicleSigns(locale == null ? null : locale.getCountry());
    }

    @Nullable
    public static String getSingleVehicleSign(@Nullable String string) {
        Locale locale = CountryCache.getInstance().getCountry(string);
        ICommonsOrderedSet iCommonsOrderedSet = (ICommonsOrderedSet)COUNTRY_TO_SIGN.get((Object)locale);
        if (iCommonsOrderedSet != null) {
            if (iCommonsOrderedSet.size() == 1) {
                return (String)iCommonsOrderedSet.getFirst();
            }
            throw new IllegalArgumentException("Multiple vehicle signs are assigned to the country locale '" + string + "': " + String.valueOf(iCommonsOrderedSet));
        }
        return null;
    }

    @Nullable
    public static String getSingleVehicleSign(@Nullable Locale locale) {
        return VehicleSigns.getSingleVehicleSign(locale == null ? null : locale.getCountry());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<Locale, ICommonsOrderedSet<String>> getCountryToVehicleSignMap() {
        return (ICommonsMap)COUNTRY_TO_SIGN.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<Locale> getAllCountriesFromVehicleSign(@Nullable String string) {
        ICommonsOrderedSet iCommonsOrderedSet = (ICommonsOrderedSet)SIGN_TO_COUNTRY.get((Object)string);
        return new CommonsLinkedHashSet((Collection)iCommonsOrderedSet);
    }

    @Nullable
    public static Locale getSingleCountryFromVehicleSign(@Nullable String string) {
        ICommonsOrderedSet iCommonsOrderedSet = (ICommonsOrderedSet)SIGN_TO_COUNTRY.get((Object)string);
        if (iCommonsOrderedSet != null) {
            if (iCommonsOrderedSet.size() == 1) {
                return (Locale)iCommonsOrderedSet.getFirst();
            }
            throw new IllegalArgumentException("Multiple country locales are assigned to the vehicle sign '" + string + "': " + String.valueOf(iCommonsOrderedSet));
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, ICommonsOrderedSet<Locale>> getVehicleSignToCountryMap() {
        return (ICommonsMap)SIGN_TO_COUNTRY.getClone();
    }

    static {
        VehicleSigns._add("AL", "AL");
        VehicleSigns._add("DZ", "DZ");
        VehicleSigns._add("AD", "AND");
        VehicleSigns._add("AR", "RA");
        VehicleSigns._add("AM", "AM");
        VehicleSigns._add("AU", "AUS");
        VehicleSigns._add("AT", "A");
        VehicleSigns._add("AZ", "AZ");
        VehicleSigns._add("BS", "BS");
        VehicleSigns._add("BH", "BRN");
        VehicleSigns._add("BD", "BD");
        VehicleSigns._add("BB", "BDS");
        VehicleSigns._add("BY", "BY");
        VehicleSigns._add("BE", "B");
        VehicleSigns._add("BZ", "BH");
        VehicleSigns._add("BJ", "DY");
        VehicleSigns._add("BA", "BIH");
        VehicleSigns._add("BW", "BW");
        VehicleSigns._add("BR", "BR");
        VehicleSigns._add("BN", "BRU");
        VehicleSigns._add("BG", "BG");
        VehicleSigns._add("KH", "KH");
        VehicleSigns._add("CA", "CDN");
        VehicleSigns._add("CF", "RCA");
        VehicleSigns._add("CL", "RCH");
        VehicleSigns._add("CN", "RC");
        VehicleSigns._add("CG", "RCB");
        VehicleSigns._add("CR", "CR");
        VehicleSigns._add("CI", "CI");
        VehicleSigns._add("HR", "HR");
        VehicleSigns._add("CU", "CU");
        VehicleSigns._add("CY", "CY");
        VehicleSigns._add("CZ", "CZ");
        VehicleSigns._add("CD", "ZRE");
        VehicleSigns._add("DK", "DK");
        VehicleSigns._add("FO", "FO");
        VehicleSigns._add("DO", "DOM");
        VehicleSigns._add("EC", "EC");
        VehicleSigns._add("EG", "ET");
        VehicleSigns._add("EE", "EST");
        VehicleSigns._add("FJ", "FJI");
        VehicleSigns._add("FI", "FIN");
        VehicleSigns._add("FR", "F");
        VehicleSigns._add("GM", "WAG");
        VehicleSigns._add("GE", "GE");
        VehicleSigns._add("DE", "D");
        VehicleSigns._add("GH", "GH");
        VehicleSigns._add("GR", "GR");
        VehicleSigns._add("GD", "WG");
        VehicleSigns._add("GT", "GCA");
        VehicleSigns._add("GY", "GUY");
        VehicleSigns._add("HT", "RH");
        VehicleSigns._add("VA", "V");
        VehicleSigns._add("HU", "H");
        VehicleSigns._add("IS", "IS");
        VehicleSigns._add("IN", "IND");
        VehicleSigns._add("ID", "RI");
        VehicleSigns._add("IR", "IR");
        VehicleSigns._add("IE", "IRL");
        VehicleSigns._add("IL", "IL");
        VehicleSigns._add("IT", "I");
        VehicleSigns._add("JM", "JA");
        VehicleSigns._add("JP", "J");
        VehicleSigns._add("JO", "HKJ");
        VehicleSigns._add("KZ", "KZ");
        VehicleSigns._add("KE", "EAK");
        VehicleSigns._add("KE", "E.A.K.");
        VehicleSigns._add("KW", "KWT");
        VehicleSigns._add("KG", "KS");
        VehicleSigns._add("LA", "LAO");
        VehicleSigns._add("LV", "LV");
        VehicleSigns._add("LB", "RL");
        VehicleSigns._add("LS", "LS");
        VehicleSigns._add("LT", "LT");
        VehicleSigns._add("LU", "L");
        VehicleSigns._add("MG", "RM");
        VehicleSigns._add("MW", "MW");
        VehicleSigns._add("MY", "MAL");
        VehicleSigns._add("ML", "RMM");
        VehicleSigns._add("MT", "M");
        VehicleSigns._add("MU", "MS");
        VehicleSigns._add("MX", "MEX");
        VehicleSigns._add("MD", "MD");
        VehicleSigns._add("MC", "MC");
        VehicleSigns._add("MN", "MGL");
        VehicleSigns._add("ME", "MNE");
        VehicleSigns._add("MA", "MA");
        VehicleSigns._add("MM", "BUR");
        VehicleSigns._add("NA", "NAM");
        VehicleSigns._add("NL", "NL");
        VehicleSigns._add("AN", "NA");
        VehicleSigns._add("NZ", "NZ");
        VehicleSigns._add("NI", "NIC");
        VehicleSigns._add("NE", "RN");
        VehicleSigns._add("NG", "WAN");
        VehicleSigns._add("NO", "N");
        VehicleSigns._add("PK", "PK");
        VehicleSigns._add("PG", "PNG");
        VehicleSigns._add("PY", "PY");
        VehicleSigns._add("PE", "PE");
        VehicleSigns._add("PH", "RP");
        VehicleSigns._add("PL", "PL");
        VehicleSigns._add("PT", "P");
        VehicleSigns._add("KP", "ROK");
        VehicleSigns._add("KR", "ROK");
        VehicleSigns._add("RU", "RUS");
        VehicleSigns._add("RW", "RWA");
        VehicleSigns._add("LC", "WL");
        VehicleSigns._add("VC", "WV");
        VehicleSigns._add("WS", "WS");
        VehicleSigns._add("SM", "RSM");
        VehicleSigns._add("SN", "SN");
        VehicleSigns._add("RS", "SRB");
        VehicleSigns._add("SC", "SY");
        VehicleSigns._add("SL", "WAL");
        VehicleSigns._add("SG", "SGP");
        VehicleSigns._add("SK", "SK");
        VehicleSigns._add("SI", "SLO");
        VehicleSigns._add("ZA", "ZA");
        VehicleSigns._add("ES", "E");
        VehicleSigns._add("LK", "CL");
        VehicleSigns._add("SR", "SME");
        VehicleSigns._add("SZ", "SD");
        VehicleSigns._add("SE", "S");
        VehicleSigns._add("CH", "CH");
        VehicleSigns._add("SY", "SYR");
        VehicleSigns._add("TJ", "TJ");
        VehicleSigns._add("TH", "T");
        VehicleSigns._add("MK", "MK");
        VehicleSigns._add("TG", "TG");
        VehicleSigns._add("TT", "TT");
        VehicleSigns._add("TN", "TN");
        VehicleSigns._add("TR", "TR");
        VehicleSigns._add("TM", "TM");
        VehicleSigns._add("UG", "EAU");
        VehicleSigns._add("UA", "UA");
        VehicleSigns._add("GB", "GB");
        VehicleSigns._add("GB", "GBA");
        VehicleSigns._add("GG", "GBG");
        VehicleSigns._add("IM", "GBM");
        VehicleSigns._add("JE", "GBJ");
        VehicleSigns._add("TZ", "EAT");
        VehicleSigns._add("TZ", "EAZ");
        VehicleSigns._add("US", "USA");
        VehicleSigns._add("UY", "ROU");
        VehicleSigns._add("UZ", "UZ");
        VehicleSigns._add("VE", "YV");
        VehicleSigns._add("ZM", "RNR");
        VehicleSigns._add("ZW", "ZW");
    }
}

