/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.unit;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasIntID;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.masterdata.unit.EISO31;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Locale;

@Immutable
public class UnitSector
implements IHasIntID,
IHasDisplayText,
Serializable {
    private final int m_nGroupNumber;
    private final IMultilingualText m_aName;
    private final EISO31 m_eISO31;

    public UnitSector(@Nonnegative int n, @Nonnull IMultilingualText iMultilingualText) {
        ValueEnforcer.isGE0((int)n, (String)"GroupNumber");
        ValueEnforcer.notNull((Object)iMultilingualText, (String)"Name");
        this.m_nGroupNumber = n;
        this.m_aName = iMultilingualText;
        this.m_eISO31 = EISO31.getFromIDOrNull(n);
    }

    @Nonnegative
    public int getID() {
        return this.m_nGroupNumber;
    }

    @Nonnull
    public IMultilingualText getName() {
        return this.m_aName;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getText(locale);
    }

    @Nullable
    public EISO31 getISO31() {
        return this.m_eISO31;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("groupNumber", this.m_nGroupNumber).append("name", (Object)this.m_aName).append("iso31", (Enum)this.m_eISO31).getToString();
    }
}

