/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.telephone;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.exception.InitializationException;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.io.resource.ClassPathResource;
import com.helger.xml.microdom.util.XMLMapHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@Immutable
public final class DialCodeManager {
    private static final ICommonsMap<String, String> COUNTRY_TO_DIAL_CODE = new CommonsHashMap();

    private DialCodeManager() {
    }

    @Nullable
    public static String getDialCodeOfCountry(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (String)COUNTRY_TO_DIAL_CODE.get((Object)string.toUpperCase(Locale.US));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getAllDialCodes() {
        return (ICommonsMap)COUNTRY_TO_DIAL_CODE.getClone();
    }

    static {
        if (XMLMapHandler.readMap((IHasInputStream)new ClassPathResource("codelists/dialcode-country-data.xml"), COUNTRY_TO_DIAL_CODE).isFailure()) {
            throw new InitializationException("Failed to init dial code country data");
        }
    }
}

