/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.masterdata.swift.IBANElement;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

@Immutable
public final class IBANElementValue
implements Serializable {
    private final IBANElement m_aElement;
    private final String m_sValue;

    public IBANElementValue(@Nonnull IBANElement iBANElement, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iBANElement, (String)"Element");
        ValueEnforcer.notNull((Object)string, (String)"Value");
        if (string.length() != iBANElement.getLength()) {
            throw new IllegalArgumentException("Value length mismatch. Having " + string.length() + " but expected " + iBANElement.getLength());
        }
        this.m_aElement = iBANElement;
        this.m_sValue = string;
    }

    @Nonnull
    public IBANElement getElement() {
        return this.m_aElement;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IBANElementValue iBANElementValue = (IBANElementValue)object;
        return this.m_aElement.equals(iBANElementValue.m_aElement) && this.m_sValue.equals(iBANElementValue.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aElement).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("element", (Object)this.m_aElement).append("value", (Object)this.m_sValue).getToString();
    }
}

