/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.postal;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.masterdata.postal.IPostalCodeCountry;
import com.helger.masterdata.postal.PostalCodeListReader;
import com.helger.text.locale.country.CountryCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@ThreadSafe
public class PostalCodeManager {
    public static final PostalCodeManager DEFAULT_MGR = new PostalCodeManager((IReadableResource)new ClassPathResource("codelists/postal-codes-20220114.xml"));
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<Locale, IPostalCodeCountry> m_aMap = new CommonsHashMap();

    public PostalCodeManager() {
    }

    public PostalCodeManager(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        PostalCodeListReader postalCodeListReader = new PostalCodeListReader(this);
        postalCodeListReader.readFromFile(iReadableResource);
    }

    public void addCountry(@Nonnull IPostalCodeCountry iPostalCodeCountry) {
        ValueEnforcer.notNull((Object)iPostalCodeCountry, (String)"PostalCountry");
        Locale locale = CountryCache.getInstance().getCountry(iPostalCodeCountry.getISO());
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)locale)) {
                throw new IllegalArgumentException("A country with code '" + String.valueOf(locale) + "' was already regsitered!");
            }
            this.m_aMap.put((Object)locale, (Object)iPostalCodeCountry);
        });
    }

    @Nullable
    public IPostalCodeCountry getPostalCountryOfCountry(@Nullable String string) {
        return this.getPostalCountryOfCountry(CountryCache.getInstance().getCountry(string));
    }

    @Nullable
    public IPostalCodeCountry getPostalCountryOfCountry(@Nullable Locale locale) {
        Locale locale2 = CountryCache.getInstance().getCountry(locale);
        return (IPostalCodeCountry)this.m_aRWLock.readLockedGet(() -> (IPostalCodeCountry)this.m_aMap.get((Object)locale2));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllAvailableCountries() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }

    @Nonnull
    public ETriState isValidPostalCode(@Nullable Locale locale, @Nullable String string) {
        IPostalCodeCountry iPostalCodeCountry = this.getPostalCountryOfCountry(locale);
        if (iPostalCodeCountry == null) {
            return ETriState.UNDEFINED;
        }
        return ETriState.valueOf((boolean)iPostalCodeCountry.isValidPostalCode(string));
    }

    public boolean isValidPostalCodeDefaultYes(@Nullable Locale locale, @Nullable String string) {
        return this.isValidPostalCode(locale, string).getAsBooleanValue(true);
    }

    public boolean isValidPostalCodeDefaultNo(@Nullable Locale locale, @Nullable String string) {
        return this.isValidPostalCode(locale, string).getAsBooleanValue(false);
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<String> getPostalCodeExamples(@Nullable Locale locale) {
        IPostalCodeCountry iPostalCodeCountry = this.getPostalCountryOfCountry(locale);
        return iPostalCodeCountry == null ? null : iPostalCodeCountry.getAllExamples();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

