/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.postal;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExCache;
import com.helger.masterdata.postal.EPostalCodeFormatElement;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;

@Immutable
public class PostalCodeFormat
implements Serializable {
    private final String m_sISO;
    private final String m_sFormat;
    private final Pattern m_aPattern;
    private final String m_sExample;

    public PostalCodeFormat(@Nonnull @Nonempty String string, @Nonnull @Nonempty List<EPostalCodeFormatElement> list) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ISO");
        ValueEnforcer.notEmpty(list, (String)"Elements");
        this.m_sISO = string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("^");
        StringBuilder stringBuilder3 = new StringBuilder();
        for (EPostalCodeFormatElement ePostalCodeFormatElement : list) {
            stringBuilder.append(ePostalCodeFormatElement.getToken());
            String string2 = ePostalCodeFormatElement.getRegEx();
            stringBuilder2.append(string2 != null ? string2 : string);
            String string3 = ePostalCodeFormatElement.getExample();
            stringBuilder3.append(string3 != null ? string3 : string);
        }
        stringBuilder2.append("$");
        this.m_sFormat = stringBuilder.toString();
        this.m_aPattern = RegExCache.getPattern((String)stringBuilder2.toString());
        this.m_sExample = stringBuilder3.toString();
    }

    @Nonnull
    @Nonempty
    public String getFormatDefinitionString() {
        return this.m_sFormat;
    }

    @Nonnull
    @Nonempty
    public String getISO() {
        return this.m_sISO;
    }

    @Nonnull
    @Nonempty
    public String getRegExPattern() {
        return this.m_aPattern.pattern();
    }

    @Nonnull
    @Nonempty
    public String getExample() {
        return this.m_sExample;
    }

    public boolean isValidPostalCode(String string) {
        return this.m_aPattern.matcher(string).matches();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("iso", (Object)this.m_sISO).append("format", (Object)this.m_sFormat).append("pattern", (Object)this.m_aPattern).append("example", (Object)this.m_sExample).getToString();
    }
}

