/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.base.clone.ICloneable;
import com.helger.base.string.StringHelper;
import com.helger.masterdata.person.ESalutation;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public interface IPersonName
extends ICloneable<IPersonName> {
    @Nullable
    public ESalutation getSalutation();

    default public boolean hasSaluation() {
        return this.getSalutation() != null;
    }

    @Nullable
    default public String getSalutationID() {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getID();
    }

    @Nullable
    default public String getSalutationDisplayName(@Nonnull Locale locale) {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getDisplayText(locale);
    }

    @Nullable
    default public String getGreeting(@Nonnull Locale locale) {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getGreeting(locale);
    }

    @Nullable
    default public String getGreetingComplete(@Nonnull Locale locale) {
        ESalutation eSalutation = this.getSalutation();
        return eSalutation == null ? null : eSalutation.getGreetingComplete(locale);
    }

    @Nullable
    public String getPrefixTitle();

    default public boolean hasPrefixTitle() {
        return StringHelper.isNotEmpty((String)this.getPrefixTitle());
    }

    @Nullable
    public String getFirstName();

    default public boolean hasFirstName() {
        return StringHelper.isNotEmpty((String)this.getFirstName());
    }

    @Nullable
    public String getMiddleName();

    default public boolean hasMiddleName() {
        return StringHelper.isNotEmpty((String)this.getMiddleName());
    }

    @Nullable
    public String getLastName();

    default public boolean hasLastName() {
        return StringHelper.isNotEmpty((String)this.getLastName());
    }

    @Nullable
    public String getSuffixTitle();

    default public boolean hasSuffixTitle() {
        return StringHelper.isNotEmpty((String)this.getSuffixTitle());
    }
}

