/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.nuts;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.masterdata.nuts.ILauManager;
import com.helger.masterdata.nuts.LauItem;
import com.helger.masterdata.nuts.NutsManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LauManager
implements ILauManager,
ICloneable<LauManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LauManager.class);
    public static final LauManager INSTANCE_2021 = LauManager.createFor2021();
    private final ICommonsOrderedMap<String, LauItem> m_aItems = new CommonsLinkedHashMap();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, LauItem> lauItems() {
        return this.m_aItems;
    }

    public void addItem(@Nonnull LauItem lauItem) {
        ValueEnforcer.notNull((Object)lauItem, (String)"Item");
        ValueEnforcer.isTrue(() -> NutsManager.isValidNutsCode(lauItem.getNutsCode()), () -> "NUTS Code '" + lauItem.getNutsCode() + "' is invalid");
        String string = lauItem.getID();
        if (this.m_aItems.containsKey((Object)string)) {
            throw new IllegalArgumentException("An item with ID '" + string + "' is already contained");
        }
        this.m_aItems.put((Object)string, (Object)lauItem);
    }

    @Nonnull
    @ReturnsMutableCopy
    public LauManager getClone() {
        LauManager lauManager = new LauManager();
        lauManager.m_aItems.putAll(this.m_aItems);
        return lauManager;
    }

    @Nonnull
    public static LauManager createFromXML(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Res");
        ValueEnforcer.isTrue(() -> ((IReadableResource)iReadableResource).exists(), (String)"Res must exist");
        LOGGER.info("Reading LAU data from XML: " + String.valueOf(iReadableResource));
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            throw new IllegalArgumentException("Failed to read " + String.valueOf(iReadableResource) + " as XML");
        }
        LauManager lauManager = new LauManager();
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("item")) {
            String string = iMicroElement.getAttributeValue("nuts");
            String string2 = iMicroElement.getAttributeValue("lau");
            String string3 = iMicroElement.getAttributeValue("name");
            String string4 = iMicroElement.getAttributeValue("latinName");
            lauManager.addItem(new LauItem(string, string2, string3, string4));
        }
        LOGGER.info("Successfully read " + lauManager.m_aItems.size() + " LAU items");
        return lauManager;
    }

    @Nonnull
    public static LauManager createFor2021() {
        return LauManager.createFromXML((IReadableResource)new ClassPathResource("codelists/lau-nuts2021.xml", LauManager.class.getClassLoader()));
    }
}

