/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.leitwegid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.CGlobal;
import com.helger.base.numeric.BigHelper;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import jakarta.annotation.Nullable;
import java.math.BigInteger;

@Immutable
public final class LeitwegID {
    public static final int MIN_COARSE_LENGTH = 2;
    public static final int MAX_COARSE_LENGTH = 12;
    public static final int MIN_FINE_LENGTH = 0;
    public static final int MAX_FINE_LENGTH = 30;
    public static final int CHECKSUM_LENGTH = 2;
    public static final char SEPARATOR_CHAR = '-';
    private static final String REGEX_LEITWEGID_CREATE = "[0-9A-Z]{2,12}(\\-[0-9A-Z]{0,30})?";
    public static final String REGEX_LEITWEGID = "[0-9A-Z]{2,12}(\\-[0-9A-Z]{0,30})?\\-[0-9]{2}";
    public static final int MIN_TOTAL_LENGTH = 5;
    public static final int MAX_TOTAL_LENGTH = 46;
    private static final BigInteger BI97 = BigInteger.valueOf(97L);

    private LeitwegID() {
    }

    private static int _calcChecksum(@Nonempty String string) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (char c : string.toCharArray()) {
            if (c >= '0' && c <= '9') {
                bigInteger = bigInteger.multiply(BigInteger.TEN).add(BigHelper.toBigInteger((int)(c - 48)));
                continue;
            }
            int n = 10 + (c - 65);
            bigInteger = bigInteger.multiply(CGlobal.BIGINT_100).add(BigHelper.toBigInteger((int)n));
        }
        bigInteger = bigInteger.multiply(CGlobal.BIGINT_100);
        int n = bigInteger.mod(BI97).intValueExact();
        return 98 - n;
    }

    public static boolean isLeitwegIDValid(@Nullable String string) {
        String string2;
        boolean bl;
        int n = StringHelper.getLength((CharSequence)string);
        if (n < 5 || n > 46) {
            return false;
        }
        if (!RegExHelper.stringMatchesPattern((String)REGEX_LEITWEGID, (String)string)) {
            return false;
        }
        String[] stringArray = StringHelper.getExplodedArray((char)'-', (String)string);
        int n2 = stringArray.length;
        if (n2 < 2 || n2 > 3) {
            throw new IllegalStateException("Unexpected part count " + n2 + " - bug in the RegEx");
        }
        if (stringArray[0].length() < 2 || stringArray[0].length() > 12) {
            return false;
        }
        boolean bl2 = bl = n2 == 3;
        if (bl) {
            if (stringArray[1].length() < 0 || stringArray[1].length() > 30) {
                return false;
            }
            string2 = stringArray[2];
        } else {
            string2 = stringArray[1];
        }
        if (string2.length() != 2) {
            return false;
        }
        int n3 = LeitwegID._calcChecksum((String)(bl ? stringArray[0] + stringArray[1] : stringArray[0]));
        return string2.equals(StringHelper.getLeadingZero((int)n3, (int)2));
    }

    @Nullable
    public static String calcLeitwegIDChecksum(@Nullable String string) {
        int n = StringHelper.getLength((CharSequence)string);
        if (n < 2 || n > 43) {
            return null;
        }
        if (!RegExHelper.stringMatchesPattern((String)REGEX_LEITWEGID_CREATE, (String)string)) {
            return null;
        }
        String[] stringArray = StringHelper.getExplodedArray((char)'-', (String)string);
        int n2 = stringArray.length;
        if (n2 < 1 || n2 > 2) {
            throw new IllegalStateException("Unexpected part count " + n2 + " - bug in the RegEx");
        }
        if (stringArray[0].length() < 2 || stringArray[0].length() > 12) {
            return null;
        }
        if (n2 == 2 && (stringArray[1].length() < 0 || stringArray[1].length() > 30)) {
            return null;
        }
        int n3 = LeitwegID._calcChecksum((String)(n2 == 2 ? stringArray[0] + stringArray[1] : stringArray[0]));
        return StringHelper.getLeadingZero((int)n3, (int)2);
    }
}

