/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.iso;

import jakarta.annotation.Nonnull;

public final class ISO7064 {
    private ISO7064() {
    }

    public static final class Mod97 {
        public static final int ILLEGAL_CHECKSUM = -1;
        public static final int EXPECTED_CHECKSUM = 1;

        private Mod97() {
        }

        public static int getChecksum(@Nonnull String string) {
            int n = 0;
            for (char c : string.toCharArray()) {
                int n2;
                if (c >= '0' && c <= '9') {
                    n2 = c - 48;
                } else if (c >= 'A' && c <= 'Z') {
                    n2 = c - 65 + 10;
                } else {
                    return -1;
                }
                n = n2 > 9 ? (100 * n + n2) % 97 : (10 * n + n2) % 97;
            }
            return n;
        }

        public static boolean isValid(@Nonnull String string) {
            return Mod97.getChecksum(string) == 1;
        }
    }
}

