/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currencyvalue;

import com.helger.annotation.CheckReturnValue;
import com.helger.base.clone.ICloneable;
import com.helger.base.numeric.BigHelper;
import com.helger.base.state.EChange;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currencyvalue.ICurrencyValue;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;

public interface IMutableCurrencyValue
extends ICurrencyValue,
ICloneable<IMutableCurrencyValue> {
    @Nonnull
    public EChange setCurrency(@Nonnull ECurrency var1);

    @Override
    @Nonnull
    @CheckReturnValue
    public IMutableCurrencyValue getAdded(@Nonnull BigDecimal var1);

    @Override
    @Nonnull
    @CheckReturnValue
    default public IMutableCurrencyValue getAdded(long l) {
        if (l == 0L) {
            return this;
        }
        return this.getAdded(BigHelper.toBigDecimal((long)l));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IMutableCurrencyValue getSubtracted(@Nonnull BigDecimal var1);

    @Override
    @Nonnull
    @CheckReturnValue
    default public IMutableCurrencyValue getSubtracted(long l) {
        if (l == 0L) {
            return this;
        }
        return this.getSubtracted(BigHelper.toBigDecimal((long)l));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IMutableCurrencyValue getMultiplied(@Nonnull BigDecimal var1);

    @Override
    @Nonnull
    @CheckReturnValue
    default public IMutableCurrencyValue getMultiplied(long l) {
        if (l == 1L) {
            return this;
        }
        return this.getMultiplied(BigHelper.toBigDecimal((long)l));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IMutableCurrencyValue getDivided(@Nonnull BigDecimal var1);

    @Override
    @Nonnull
    @CheckReturnValue
    default public IMutableCurrencyValue getDivided(long l) {
        if (l == 1L) {
            return this;
        }
        return this.getDivided(BigHelper.toBigDecimal((long)l));
    }

    @Nonnull
    public EChange setValue(@Nonnull BigDecimal var1);

    public void addValue(@Nonnull BigDecimal var1);
}

