/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.thread;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.timing.StopWatch;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsNavigableSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.helper.CollectionSort;
import com.helger.xml.microdom.IHasMicroNodeRepresentation;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.util.thread.ThreadDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadDescriptorList
implements IHasMicroNodeRepresentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDescriptorList.class);
    private final ICommonsList<ThreadDescriptor> m_aList = new CommonsArrayList();
    private String m_sError;

    public @NonNull ThreadDescriptorList addDescriptor(@NonNull ThreadDescriptor threadDescriptor) {
        ValueEnforcer.notNull((Object)threadDescriptor, (String)"Descriptor");
        this.m_aList.add((Object)threadDescriptor);
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ThreadDescriptor> getAllDescriptors() {
        return (ICommonsList)this.m_aList.getClone();
    }

    public @NonNull ThreadDescriptorList setError(@Nullable String string) {
        this.m_sError = string;
        return this;
    }

    public @Nullable String getError() {
        return this.m_sError;
    }

    @ReturnsMutableCopy
    private @NonNull ICommonsMap<Thread.State, ICommonsNavigableSet<Long>> _getStateMap() {
        CommonsEnumMap commonsEnumMap = new CommonsEnumMap(Thread.State.class);
        for (ThreadDescriptor threadDescriptor : this.m_aList) {
            Thread.State state2 = threadDescriptor.getThreadState();
            ICommonsNavigableSet iCommonsNavigableSet = (ICommonsNavigableSet)commonsEnumMap.computeIfAbsent((Object)state2, state -> new CommonsTreeSet());
            iCommonsNavigableSet.add((Object)threadDescriptor.getThreadID());
        }
        return commonsEnumMap;
    }

    @Nonempty
    public @NonNull String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.m_sError;
        if (StringHelper.isNotEmpty((String)string)) {
            stringBuilder.append("ERROR retrieving all thread stack traces: ").append(this.m_sError).append("\n\n");
        }
        stringBuilder.append("Total thread count: ").append(this.m_aList.size()).append('\n');
        ICommonsMap<Thread.State, ICommonsNavigableSet<Long>> iCommonsMap = this._getStateMap();
        for (Thread.State state : Thread.State.values()) {
            ICommonsSet iCommonsSet = (ICommonsSet)iCommonsMap.get((Object)state);
            int n = iCommonsSet.size();
            stringBuilder.append("Thread state ").append((Object)state).append(" [").append(n).append(']');
            if (n > 0) {
                stringBuilder.append(": ").append(iCommonsSet.toString());
            }
            stringBuilder.append('\n');
        }
        for (ThreadDescriptor threadDescriptor : this.m_aList) {
            stringBuilder.append('\n').append(threadDescriptor.getAsString());
        }
        return stringBuilder.toString();
    }

    @Override
    public @NonNull IMicroElement getAsMicroNode() {
        MicroElement microElement = new MicroElement("threadlist");
        String string = this.m_sError;
        if (StringHelper.isNotEmpty((String)string)) {
            microElement.addElement("error").addText(this.m_sError);
        }
        microElement.setAttribute("threadcount", this.m_aList.size());
        ICommonsMap<Thread.State, ICommonsNavigableSet<Long>> iCommonsMap = this._getStateMap();
        for (Thread.State state : Thread.State.values()) {
            ICommonsSet iCommonsSet = (ICommonsSet)iCommonsMap.get((Object)state);
            int n = iCommonsSet.size();
            IMicroElement iMicroElement = microElement.addElement("threadstate");
            iMicroElement.setAttribute("id", state.toString());
            iMicroElement.setAttribute("threadcount", n);
            if (n <= 0) continue;
            iMicroElement.addText(StringImplode.getImploded((char)',', (Collection)iCommonsSet));
        }
        for (ThreadDescriptor threadDescriptor : this.m_aList) {
            microElement.addChild(threadDescriptor.getAsMicroNode());
        }
        return microElement;
    }

    @Nonempty
    private static @NonNull String _getAsString(@NonNull Throwable throwable) {
        return throwable.getMessage() + " -- " + throwable.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ThreadDescriptorList createWithAllThreads() {
        StopWatch stopWatch = StopWatch.createdStarted();
        ThreadDescriptorList threadDescriptorList = new ThreadDescriptorList();
        try {
            for (Map.Entry entry : CollectionSort.getSortedByKey(Thread.getAllStackTraces(), Comparator.comparing(Thread::getId)).entrySet()) {
                Object[] objectArray = (StackTraceElement[])entry.getValue();
                String string = ArrayHelper.isEmpty((Object[])objectArray) ? "No stack trace available!\n" : StackTraceHelper.getStackAsString((StackTraceElement[])objectArray, (boolean)false);
                threadDescriptorList.addDescriptor(new ThreadDescriptor((Thread)entry.getKey(), string));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error collecting all thread descriptors", (Throwable)exception);
            threadDescriptorList.setError("Error collecting all thread descriptors: " + ThreadDescriptorList._getAsString(exception));
        }
        finally {
            long l = stopWatch.stopAndGetMillis();
            if (l > 1000L) {
                LOGGER.warn("Took " + l + " ms to get all thread descriptors!");
            }
        }
        return threadDescriptorList;
    }
}

