/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.xml.sax.SAXParseException;

@ThreadSafe
public class CollectingSAXErrorHandler
extends AbstractSAXErrorHandler {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    protected final ErrorList m_aErrors;

    public CollectingSAXErrorHandler() {
        this(ErrorList::new);
    }

    protected CollectingSAXErrorHandler(@NonNull Supplier<? extends ErrorList> supplier) {
        this.m_aErrors = supplier.get();
        if (this.m_aErrors == null) {
            throw new IllegalStateException("ErrorListProvider returned a null value");
        }
    }

    @Override
    protected void internalLog(@NonNull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        IError iError = CollectingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException);
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aErrors.add((Object)iError));
    }

    @ReturnsMutableCopy
    public @NonNull IErrorList getErrorList() {
        return (IErrorList)this.m_aRWLock.readLockedGet(() -> ((ErrorList)this.m_aErrors).getClone());
    }

    public boolean containsAtLeastOneError() {
        return this.m_aRWLock.readLockedBoolean(() -> ((ErrorList)this.m_aErrors).containsAtLeastOneError());
    }

    public @NonNull EChange clearResourceErrors() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> ((ErrorList)this.m_aErrors).removeAll());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("errors", (Object)this.m_aErrors).getToString();
    }
}

