/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.ls;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.ls.AbstractLSResourceResolver;
import com.helger.xml.ls.LSResourceData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

@ThreadSafe
public class CollectingLSResourceResolver
extends AbstractLSResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectingLSResourceResolver.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<LSResourceData> m_aList = new CommonsArrayList();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<LSResourceData> getAllRequestedResources() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aList.getClone());
    }

    @Override
    @Nullable
    public LSInput mainResolveResource(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        LSResourceData lSResourceData = new LSResourceData(string, string2, string3, string4, string5);
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aList.add((Object)lSResourceData));
        return null;
    }
}

