/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.SAXParseException;

@ThreadSafe
public class CollectingSAXErrorHandler
extends AbstractSAXErrorHandler {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    protected final ErrorList m_aErrors;

    public CollectingSAXErrorHandler() {
        this(ErrorList::new);
    }

    protected CollectingSAXErrorHandler(@Nonnull Supplier<? extends ErrorList> supplier) {
        this.m_aErrors = supplier.get();
        if (this.m_aErrors == null) {
            throw new IllegalStateException("ErrorListProvider returned a null value");
        }
    }

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        IError iError = CollectingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException);
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aErrors.add((Object)iError));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return (IErrorList)this.m_aRWLock.readLockedGet(() -> ((ErrorList)this.m_aErrors).getClone());
    }

    public boolean containsAtLeastOneError() {
        return this.m_aRWLock.readLockedBoolean(() -> ((ErrorList)this.m_aErrors).containsAtLeastOneError());
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> ((ErrorList)this.m_aErrors).removeAll());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("errors", (Object)this.m_aErrors).getToString();
    }
}

