/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url.protocol;

import com.helger.annotation.Nonempty;
import com.helger.url.protocol.IURLProtocol;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EURLProtocol implements IURLProtocol
{
    HTTP("http://"),
    HTTPS("https://"),
    FILE("file://"),
    FTP("ftp://"),
    BUNDLE("bundle://"),
    CALLTO("callto:"),
    DATA("data:"),
    FTPS("ftps://"),
    GEO("geo:"),
    GOPHER("gopher://"),
    JAR("jar:"),
    JAVASCRIPT("javascript:"),
    LDAP("ldap:"),
    MAILTO("mailto:"),
    MMS("mms:"),
    NEWS("news:"),
    NNTP("nntp:"),
    POP("pop://"),
    RSYNC("rsync:"),
    RTMP("rtmp://"),
    RTSP("rtsp://"),
    RTSPU("rtspu://"),
    SCP("scp://"),
    SFTP("sftp://"),
    SHTTP("shttp://"),
    SIP("sip:"),
    SIPS("sips:"),
    TEL("tel:"),
    TELNET("telnet://"),
    URN("urn:"),
    WS("ws://"),
    WSJAR("wsjar:"),
    WSS("wss://"),
    ZIP("zip:"),
    CID("cid:"),
    MID("mid:"),
    JRT("jrt:");

    private final String m_sProtocol;

    private EURLProtocol(String string2) {
        this.m_sProtocol = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public boolean isUsedInURL(@Nullable String string) {
        return string != null && string.startsWith(this.m_sProtocol, 0);
    }

    @Override
    @Nullable
    public String getWithProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.m_sProtocol + string;
    }

    @Override
    public boolean allowsForQueryParameters() {
        return this == HTTP || this == HTTPS || this == MAILTO || this == SHTTP;
    }
}

