/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.text.IMultilingualText;
import com.helger.text.MultilingualText;
import com.helger.text.locale.LocaleCache;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.NonNull;

@Immutable
public final class TextHelper {
    public static final Locale DE = LocaleCache.getInstance().getLocale("de");
    public static final Locale EN = LocaleCache.getInstance().getLocale("en");
    private static final TextHelper INSTANCE = new TextHelper();

    private TextHelper() {
    }

    @ReturnsMutableCopy
    public static @NonNull MultilingualText create_DE(@NonNull String string) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(DE, string);
        return multilingualText;
    }

    @ReturnsMutableCopy
    public static @NonNull MultilingualText create_EN(@NonNull String string) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(EN, string);
        return multilingualText;
    }

    @ReturnsMutableCopy
    public static @NonNull MultilingualText create_DE_EN(@NonNull String string, @NonNull String string2) {
        MultilingualText multilingualText = new MultilingualText();
        multilingualText.addText(DE, string);
        multilingualText.addText(EN, string2);
        return multilingualText;
    }

    @ReturnsMutableCopy
    public static @NonNull MultilingualText getCopyWithLocales(@NonNull IMultilingualText iMultilingualText, @NonNull Collection<Locale> collection) {
        MultilingualText multilingualText = new MultilingualText();
        for (Locale locale : collection) {
            if (!iMultilingualText.texts().containsKey((Object)locale)) continue;
            multilingualText.setText(locale, iMultilingualText.getText(locale));
        }
        return multilingualText;
    }

    @ReturnsMutableCopy
    public static @NonNull MultilingualText createMultilingualTextFromMap(@NonNull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"Map");
        MultilingualText multilingualText = new MultilingualText();
        LocaleCache localeCache = LocaleCache.getInstance();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            if (string == null) continue;
            multilingualText.setText(localeCache.getLocale(entry.getKey()), string);
        }
        return multilingualText;
    }
}

