/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resourcebundle;

import com.helger.annotation.Nonempty;
import com.helger.annotation.PropertyKey;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.resourcebundle.ResourceBundleHelper;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class ResourceBundleKey {
    private final String m_sBundleName;
    private final String m_sKey;

    public ResourceBundleKey(@Nonempty @NonNull String string, @PropertyKey @Nonempty @NonNull String string2) {
        this.m_sBundleName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"BundleName");
        this.m_sKey = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"Key");
    }

    @Nonempty
    public @NonNull String getBundleName() {
        return this.m_sBundleName;
    }

    @PropertyKey
    @Nonempty
    public @NonNull String getKey() {
        return this.m_sKey;
    }

    public @Nullable String getString(@NonNull Locale locale) {
        return ResourceBundleHelper.getString(this.m_sBundleName, locale, this.m_sKey);
    }

    public @Nullable String getString(@NonNull Locale locale, @NonNull ClassLoader classLoader) {
        return ResourceBundleHelper.getString(this.m_sBundleName, locale, this.m_sKey, classLoader);
    }

    public @Nullable String getUtf8String(@NonNull Locale locale) {
        return ResourceBundleHelper.getUtf8String(this.m_sBundleName, locale, this.m_sKey);
    }

    public @Nullable String getUtf8String(@NonNull Locale locale, @NonNull ClassLoader classLoader) {
        return ResourceBundleHelper.getUtf8String(this.m_sBundleName, locale, this.m_sKey, classLoader);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceBundleKey resourceBundleKey = (ResourceBundleKey)object;
        return this.m_sBundleName.equals(resourceBundleKey.m_sBundleName) && this.m_sKey.equals(resourceBundleKey.m_sKey);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sBundleName).append((Object)this.m_sKey).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("bundleName", (Object)this.m_sBundleName).append("key", (Object)this.m_sKey).getToString();
    }
}

