/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.codepoint;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.compare.CompareHelper;
import com.helger.base.compare.IComparable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringEncoding;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.codepoint.CodepointHelper;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jspecify.annotations.NonNull;

@Immutable
public class Codepoint
implements IComparable<Codepoint> {
    private final int m_nValue;

    public Codepoint(@NonNull byte[] byArray, @NonNull Charset charset) {
        this(StringEncoding.decodeBytesToChars((byte[])byArray, (Charset)charset));
    }

    private static int _getValueFromCharSequence(@NonNull CharSequence charSequence) {
        ValueEnforcer.notNull((Object)charSequence, (String)"CharSequence");
        int n = charSequence.length();
        if (n == 1) {
            return charSequence.charAt(0);
        }
        if (n > 2) {
            throw new IllegalArgumentException("Char sequence too long (" + n + ") '" + String.valueOf(charSequence) + "'");
        }
        return Character.toCodePoint(charSequence.charAt(0), charSequence.charAt(1));
    }

    public Codepoint(@NonNull CharSequence charSequence) {
        this(Codepoint._getValueFromCharSequence(charSequence));
    }

    public Codepoint(@NonNull String string) {
        this(string.toCharArray());
    }

    private static int _getValueFromCharArray(@NonNull char[] cArray) {
        ValueEnforcer.notEmpty((char[])cArray, (String)"CharArray");
        int n = cArray.length;
        if (n == 1) {
            return cArray[0];
        }
        if (n > 2) {
            throw new IllegalArgumentException("Array too long (" + n + "): " + Arrays.toString(cArray));
        }
        return Character.toCodePoint(cArray[0], cArray[1]);
    }

    public Codepoint(@NonNull char[] cArray) {
        this(Codepoint._getValueFromCharArray(cArray));
    }

    public Codepoint(char c) {
        this((int)c);
    }

    public Codepoint(char c, char c2) {
        this(Character.toCodePoint(c, c2));
    }

    public Codepoint(@NonNull Codepoint codepoint) {
        this(codepoint.m_nValue);
    }

    public Codepoint(@Nonnegative int n) {
        ValueEnforcer.isTrue((boolean)Character.isValidCodePoint(n), () -> "Invalid Codepoint: " + n);
        this.m_nValue = n;
    }

    protected Codepoint(@Nonnegative int n, boolean bl) {
        this.m_nValue = n;
    }

    @Nonnegative
    public final int getValue() {
        return this.m_nValue;
    }

    public final boolean isSupplementary() {
        return Character.isSupplementaryCodePoint(this.m_nValue);
    }

    public final boolean isLowSurrogate() {
        return this.m_nValue >= 56320 && this.m_nValue < 57344;
    }

    public final boolean isHighSurrogate() {
        return this.m_nValue >= 55296 && this.m_nValue < 56320;
    }

    public final char getHighSurrogate() {
        return CodepointHelper.getHighSurrogate(this.m_nValue);
    }

    public final char getLowSurrogate() {
        return CodepointHelper.getLowSurrogate(this.m_nValue);
    }

    public boolean isBidi() {
        return CodepointHelper.isBidi(this.m_nValue);
    }

    public boolean isDigit() {
        return Character.isDigit(this.m_nValue);
    }

    public boolean isAlpha() {
        return Character.isLetter(this.m_nValue);
    }

    public boolean isAlphaDigit() {
        return Character.isLetterOrDigit(this.m_nValue);
    }

    @Nonempty
    public @NonNull String getAsString() {
        return CodepointHelper.getAsString(this.m_nValue);
    }

    @ReturnsMutableCopy
    public @NonNull char[] getAsChars() {
        return Character.toChars(this.m_nValue);
    }

    @Nonnegative
    public int getCharCount() {
        return Character.charCount(this.m_nValue);
    }

    public @NonNull byte[] getAsBytes(@NonNull Charset charset) {
        return this.getAsString().getBytes(charset);
    }

    public final int getPlane() {
        return this.m_nValue / 65536;
    }

    public final @NonNull Codepoint next() {
        if (this.m_nValue == 0x10FFFF) {
            throw new IndexOutOfBoundsException();
        }
        return new Codepoint(this.m_nValue + 1);
    }

    public final @NonNull Codepoint previous() {
        if (this.m_nValue == 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Codepoint(this.m_nValue - 1);
    }

    public void appendTo(@NonNull StringBuilder stringBuilder) {
        stringBuilder.append(this.getAsChars());
    }

    public int compareTo(@NonNull Codepoint codepoint) {
        return CompareHelper.compare((int)this.m_nValue, (int)codepoint.m_nValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Codepoint codepoint = (Codepoint)object;
        return this.m_nValue == codepoint.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Value", this.m_nValue).getToString();
    }
}

