/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.mac;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.WrappedInputStream;
import com.helger.base.tostring.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import org.jspecify.annotations.NonNull;

public class MacInputStream
extends WrappedInputStream {
    public static final boolean DEFAULT_ON = true;
    private Mac m_aMac;
    private boolean m_bOn = true;

    public MacInputStream(@NonNull InputStream inputStream, @NonNull Mac mac) {
        super(inputStream);
        this.setMac(mac);
    }

    public final @NonNull Mac getMac() {
        return this.m_aMac;
    }

    public final void setMac(@NonNull Mac mac) {
        ValueEnforcer.notNull((Object)mac, (String)"Mac");
        this.m_aMac = mac;
    }

    public final void setOn(boolean bl) {
        this.m_bOn = bl;
    }

    public final boolean isOn() {
        return this.m_bOn;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (this.m_bOn && n != -1) {
            this.m_aMac.update((byte)n);
        }
        return n;
    }

    public int read(@NonNull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.m_bOn && n3 != -1) {
            this.m_aMac.update(byArray, n, n3);
        }
        return n3;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Mac", (Object)this.m_aMac).append("On", this.m_bOn).getToString();
    }
}

