/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.base.builder.IBuilder;
import com.helger.base.string.StringHelper;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreDescriptor;
import java.security.Provider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class KeyStoreDescriptorBuilder
implements IBuilder<KeyStoreDescriptor> {
    private IKeyStoreType m_aType;
    private String m_sPath;
    private char[] m_aPassword;
    private Provider m_aProvider;

    public KeyStoreDescriptorBuilder() {
    }

    public KeyStoreDescriptorBuilder(@NonNull KeyStoreDescriptor keyStoreDescriptor) {
        this.type(keyStoreDescriptor.m_aType).path(keyStoreDescriptor.m_sPath).password(keyStoreDescriptor.m_aPassword).provider(keyStoreDescriptor.m_aProvider);
    }

    public final @NonNull KeyStoreDescriptorBuilder type(@Nullable IKeyStoreType iKeyStoreType) {
        this.m_aType = iKeyStoreType;
        return this;
    }

    public final @NonNull KeyStoreDescriptorBuilder path(@Nullable String string) {
        this.m_sPath = string;
        return this;
    }

    public final @NonNull KeyStoreDescriptorBuilder password(@Nullable String string) {
        return this.password(string == null ? null : string.toCharArray());
    }

    public final @NonNull KeyStoreDescriptorBuilder password(@Nullable char[] cArray) {
        this.m_aPassword = cArray;
        return this;
    }

    public final @NonNull KeyStoreDescriptorBuilder provider(@Nullable Provider provider) {
        this.m_aProvider = provider;
        return this;
    }

    public @NonNull KeyStoreDescriptor build() throws IllegalStateException {
        if (this.m_aType == null) {
            throw new IllegalStateException("Type is missing");
        }
        if (StringHelper.isEmpty((String)this.m_sPath)) {
            throw new IllegalStateException("Path is empty");
        }
        if (this.m_aPassword == null) {
            throw new IllegalStateException("Password is missing");
        }
        return new KeyStoreDescriptor(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
    }
}

