/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.mime.IMimeType;
import java.io.IOException;
import java.io.OutputStream;
import org.jspecify.annotations.NonNull;

@Immutable
@MustImplementEqualsAndHashcode
public class MimeTypeContent {
    public static final boolean DEFAULT_COPY_BYTES = true;
    private final ByteArrayWrapper m_aContentBytes;
    private final IMimeType m_aMimeType;

    public MimeTypeContent(@Nonempty @NonNull byte[] byArray, @NonNull IMimeType iMimeType) {
        this(byArray, true, iMimeType);
    }

    public MimeTypeContent(@Nonempty @NonNull byte[] byArray, boolean bl, @NonNull IMimeType iMimeType) {
        ValueEnforcer.notEmpty((byte[])byArray, (String)"ContentBytes");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        this.m_aContentBytes = new ByteArrayWrapper(byArray, bl);
        this.m_aMimeType = iMimeType;
    }

    @Nonempty
    @ReturnsMutableCopy
    public @NonNull byte[] getAllContentBytes() {
        return this.m_aContentBytes.getAllBytes();
    }

    @Nonnegative
    public int getContentByteCount() {
        return this.m_aContentBytes.size();
    }

    public void writeContentBytes(@WillNotClose @NonNull OutputStream outputStream) throws IOException {
        this.m_aContentBytes.writeTo(outputStream);
    }

    public @NonNull IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    public boolean matchesBeginning(@NonNull byte[] byArray) {
        return ArrayHelper.startsWith((byte[])byArray, (byte[])this.m_aContentBytes.bytes());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeContent mimeTypeContent = (MimeTypeContent)object;
        return this.m_aContentBytes.equals((Object)mimeTypeContent.m_aContentBytes) && this.m_aMimeType.equals(mimeTypeContent.m_aMimeType);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aContentBytes).append((Object)this.m_aMimeType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ContentBytes", (Object)this.m_aContentBytes).append("MimeType", (Object)this.m_aMimeType).getToString();
    }
}

