/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementComparable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.collection.commons.ICommonsList;
import com.helger.mime.CMimeType;
import com.helger.mime.EMimeContentType;
import com.helger.mime.EMimeQuoting;
import com.helger.mime.MimeTypeParameter;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
@MustImplementComparable
public interface IMimeType
extends ICloneable<IMimeType> {
    public @NonNull EMimeContentType getContentType();

    public @NonNull String getContentSubType();

    default public @NonNull String getAsString() {
        return this.getAsString(CMimeType.DEFAULT_QUOTING);
    }

    @Nonempty
    public @NonNull String getAsString(@NonNull EMimeQuoting var1);

    @Nonempty
    public @NonNull String getAsStringWithoutParameters();

    public @NonNull String getParametersAsString(@NonNull EMimeQuoting var1);

    public boolean hasAnyParameters();

    @Nonnegative
    public int getParameterCount();

    @ReturnsMutableCopy
    public @NonNull ICommonsList<MimeTypeParameter> getAllParameters();

    public @Nullable MimeTypeParameter getParameterAtIndex(@Nonnegative int var1);

    default public boolean hasParameterWithName(@Nullable String string) {
        return this.getParameterWithName(string) != null;
    }

    public @Nullable MimeTypeParameter getParameterWithName(@Nullable String var1);

    public @Nullable String getParameterValueWithName(@Nullable String var1);

    public @NonNull IMimeType getCopyWithoutParameters();
}

