/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementComparable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.collection.commons.ICommonsList;
import com.helger.mime.CMimeType;
import com.helger.mime.EMimeContentType;
import com.helger.mime.EMimeQuoting;
import com.helger.mime.MimeTypeParameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@MustImplementEqualsAndHashcode
@MustImplementComparable
public interface IMimeType
extends ICloneable<IMimeType> {
    @Nonnull
    public EMimeContentType getContentType();

    @Nonnull
    public String getContentSubType();

    @Nonnull
    default public String getAsString() {
        return this.getAsString(CMimeType.DEFAULT_QUOTING);
    }

    @Nonnull
    @Nonempty
    public String getAsString(@Nonnull EMimeQuoting var1);

    @Nonnull
    @Nonempty
    public String getAsStringWithoutParameters();

    @Nonnull
    public String getParametersAsString(@Nonnull EMimeQuoting var1);

    public boolean hasAnyParameters();

    @Nonnegative
    public int getParameterCount();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeParameter> getAllParameters();

    @Nullable
    public MimeTypeParameter getParameterAtIndex(@Nonnegative int var1);

    default public boolean hasParameterWithName(@Nullable String string) {
        return this.getParameterWithName(string) != null;
    }

    @Nullable
    public MimeTypeParameter getParameterWithName(@Nullable String var1);

    @Nullable
    public String getParameterValueWithName(@Nullable String var1);

    @Nonnull
    public IMimeType getCopyWithoutParameters();
}

