/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.convert;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.json.IHasJson;
import com.helger.json.IJson;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.JsonValue;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Map;

@Immutable
public final class JsonConverter {
    private static final JsonConverter INSTANCE = new JsonConverter();

    private JsonConverter() {
    }

    @Nonnull
    public static IJson convertToJson(@Nullable Object object) {
        if (object == null) {
            return JsonValue.NULL;
        }
        if (object instanceof IJson) {
            IJson iJson = (IJson)object;
            return iJson;
        }
        if (object instanceof IHasJson) {
            IHasJson iHasJson = (IHasJson)object;
            return iHasJson.getAsJson();
        }
        if (ArrayHelper.isArray((Object)object)) {
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                return (IJson)new JsonArray(blArray.length).addAll(blArray);
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return (IJson)new JsonArray(byArray.length).addAll(byArray);
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return (IJson)new JsonArray(cArray.length).addAll(cArray);
            }
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                return (IJson)new JsonArray(dArray.length).addAll(dArray);
            }
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                return (IJson)new JsonArray(fArray.length).addAll(fArray);
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                return (IJson)new JsonArray(nArray.length).addAll(nArray);
            }
            if (object instanceof long[]) {
                long[] lArray = (long[])object;
                return (IJson)new JsonArray(lArray.length).addAll(lArray);
            }
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                return (IJson)new JsonArray(sArray.length).addAll(sArray);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                JsonArray jsonArray = new JsonArray(objectArray.length);
                for (Object object2 : objectArray) {
                    jsonArray.add(JsonConverter.convertToJson(object2));
                }
                return jsonArray;
            }
            throw new IllegalStateException("Expected an array but got none. Object=" + String.valueOf(object));
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            JsonArray jsonArray = new JsonArray(collection.size());
            for (Object e : collection) {
                jsonArray.add(JsonConverter.convertToJson(e));
            }
            return jsonArray;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonObject jsonObject = new JsonObject(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)TypeConverter.convert(entry.getKey(), String.class);
                if (string == null) {
                    throw new IllegalArgumentException("Map key '" + String.valueOf(entry.getKey()) + "' could not be converted to a String!");
                }
                IJson iJson = JsonConverter.convertToJson(entry.getValue());
                jsonObject.add(string, iJson);
            }
            return jsonObject;
        }
        return JsonValue.create(object);
    }
}

