/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.jaxb.validation.AbstractValidationEventHandler;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LoggingValidationEventHandler
extends AbstractValidationEventHandler {
    public static final LoggingValidationEventHandler DEFAULT_INSTANCE = new LoggingValidationEventHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingValidationEventHandler.class);

    @Override
    protected void onEvent(@NonNull IError iError) {
        String string = "JAXB " + iError.getAsString(Locale.US);
        if (iError.getErrorLevel().isLE((IErrorLevel)EErrorLevel.WARN)) {
            LOGGER.warn(string, iError.getLinkedException());
        } else {
            LOGGER.error(string, iError.getLinkedException());
        }
    }
}

