/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.WillClose;
import com.helger.base.io.EAppend;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.ByteBufferOutputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.io.file.FileHelper;
import com.helger.io.resource.IWritableResource;
import com.helger.jaxb.IJAXBMarshaller;
import com.helger.xml.XMLFactory;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroSAXHandler;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.SafeXMLStreamWriter;
import com.helger.xml.transform.TransformResultFactory;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public interface IJAXBWriter<JAXBTYPE> {
    public static final boolean USE_JAXB_CHARSET_FIX = true;

    public @Nullable NamespaceContext getNamespaceContext();

    public boolean isFormattedOutput();

    public @Nullable Charset getCharset();

    default public boolean hasCharset() {
        return this.getCharset() != null;
    }

    public @Nullable String getIndentString();

    default public boolean hasIndentString() {
        return StringHelper.isNotEmpty((String)this.getIndentString());
    }

    public boolean isUseSchema();

    public @Nullable String getSchemaLocation();

    default public boolean hasSchemaLocation() {
        return StringHelper.isNotEmpty((String)this.getSchemaLocation());
    }

    public @Nullable String getNoNamespaceSchemaLocation();

    default public boolean hasNoNamespaceSchemaLocation() {
        return StringHelper.isNotEmpty((String)this.getNoNamespaceSchemaLocation());
    }

    public @NonNull IXMLWriterSettings getXMLWriterSettings();

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @NonNull File file) {
        NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream((File)file);
        if (nonBlockingBufferedOutputStream == null) {
            return ESuccess.FAILURE;
        }
        return this.write(JAXBTYPE, (OutputStream)nonBlockingBufferedOutputStream);
    }

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @NonNull Path path) {
        return this.write(JAXBTYPE, path.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @WillClose @NonNull OutputStream outputStream) {
        try {
            ESuccess eSuccess = this.write(JAXBTYPE, (XMLStreamWriter)SafeXMLStreamWriter.create((OutputStream)outputStream, (IXMLWriterSettings)this.getXMLWriterSettings()));
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @WillClose @NonNull Writer writer) {
        try {
            ESuccess eSuccess = this.write(JAXBTYPE, (XMLStreamWriter)SafeXMLStreamWriter.create((Writer)writer, (IXMLWriterSettings)this.getXMLWriterSettings()));
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @NonNull ByteBuffer byteBuffer) {
        return this.write(JAXBTYPE, (OutputStream)new ByteBufferOutputStream(byteBuffer, false));
    }

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @NonNull IWritableResource iWritableResource) {
        OutputStream outputStream = iWritableResource.getOutputStream(EAppend.TRUNCATE);
        if (outputStream == null) {
            return ESuccess.FAILURE;
        }
        return this.write(JAXBTYPE, outputStream);
    }

    public @NonNull ESuccess write(@NonNull JAXBTYPE var1, @NonNull IJAXBMarshaller<JAXBTYPE> var2);

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @NonNull Result result) {
        if (result instanceof StreamResult) {
            LoggerFactory.getLogger(IJAXBWriter.class).warn("Potentially invalid XML is created by using StreamResult object: " + String.valueOf(result));
        }
        return this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, result));
    }

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @NonNull ContentHandler contentHandler) {
        return this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, contentHandler));
    }

    default public @NonNull ESuccess write(@NonNull JAXBTYPE JAXBTYPE, @WillClose @NonNull XMLStreamWriter xMLStreamWriter) {
        ESuccess eSuccess = this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, xMLStreamWriter));
        try {
            xMLStreamWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalStateException("Failed to flush XMLStreamWriter", xMLStreamException);
        }
        try {
            xMLStreamWriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalStateException("Failed to close XMLStreamWriter", xMLStreamException);
        }
        return eSuccess;
    }

    default public @Nullable Document getAsDocument(@NonNull JAXBTYPE JAXBTYPE) {
        Document document = XMLFactory.newDocument();
        return this.write(JAXBTYPE, TransformResultFactory.create((Node)document)).isSuccess() ? document : null;
    }

    default public @Nullable Element getAsElement(@NonNull JAXBTYPE JAXBTYPE) {
        Document document = this.getAsDocument(JAXBTYPE);
        return document == null ? null : document.getDocumentElement();
    }

    default public @Nullable IMicroDocument getAsMicroDocument(@NonNull JAXBTYPE JAXBTYPE) {
        MicroSAXHandler microSAXHandler = new MicroSAXHandler(false, null, true);
        return this.write(JAXBTYPE, (ContentHandler)microSAXHandler).isSuccess() ? microSAXHandler.getDocument() : null;
    }

    default public @Nullable IMicroElement getAsMicroElement(@NonNull JAXBTYPE JAXBTYPE) {
        IMicroDocument iMicroDocument = this.getAsMicroDocument(JAXBTYPE);
        if (iMicroDocument == null) {
            return null;
        }
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        iMicroElement.detachFromParent();
        return iMicroElement;
    }

    default public @Nullable String getAsString(@NonNull JAXBTYPE JAXBTYPE) {
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();){
            String string = this.write(JAXBTYPE, (XMLStreamWriter)SafeXMLStreamWriter.create((Writer)nonBlockingStringWriter, (IXMLWriterSettings)this.getXMLWriterSettings())).isSuccess() ? nonBlockingStringWriter.getAsString() : null;
            return string;
        }
    }

    default public @Nullable ByteBuffer getAsByteBuffer(@NonNull JAXBTYPE JAXBTYPE) {
        try (ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();){
            ByteBuffer byteBuffer = this.write(JAXBTYPE, (XMLStreamWriter)SafeXMLStreamWriter.create((OutputStream)byteBufferOutputStream, (IXMLWriterSettings)this.getXMLWriterSettings())).isFailure() ? null : byteBufferOutputStream.getBuffer();
            return byteBuffer;
        }
    }

    default public @Nullable byte[] getAsBytes(@NonNull JAXBTYPE JAXBTYPE) {
        try (ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();){
            byte[] byArray = this.write(JAXBTYPE, (XMLStreamWriter)SafeXMLStreamWriter.create((OutputStream)byteBufferOutputStream, (IXMLWriterSettings)this.getXMLWriterSettings())).isFailure() ? null : byteBufferOutputStream.getAsByteArray();
            return byArray;
        }
    }

    default public @Nullable NonBlockingByteArrayInputStream getAsInputStream(@NonNull JAXBTYPE JAXBTYPE) {
        byte[] byArray = this.getAsBytes(JAXBTYPE);
        return byArray == null ? null : new NonBlockingByteArrayInputStream(byArray);
    }
}

