/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.clone.CloneHelper;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeCalculator;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.reflection.GenericReflection;
import jakarta.xml.bind.JAXBElement;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class JAXBHelper {
    private JAXBHelper() {
    }

    private static boolean _anyEquals(@Nullable Object object, @Nullable Object object2) {
        if (EqualsHelper.identityEqual((Object)object, (Object)object2)) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!object.getClass().equals(object2.getClass())) {
            return false;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Arrays.equals(byArray, (byte[])object2);
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return JAXBHelper.equalDOMNodes(node, (Node)object2);
        }
        if (object instanceof JAXBElement) {
            JAXBElement jAXBElement = (JAXBElement)object;
            return JAXBHelper.equalJAXBElements(jAXBElement, (JAXBElement)object2);
        }
        if (object instanceof List) {
            return JAXBHelper.equalListAnys((List)GenericReflection.uncheckedCast((Object)object), (List)GenericReflection.uncheckedCast((Object)object2));
        }
        return EqualsHelper.equals((Object)object, (Object)object2);
    }

    public static boolean equalJAXBElements(@Nullable JAXBElement<?> jAXBElement, @Nullable JAXBElement<?> jAXBElement2) {
        if (EqualsHelper.identityEqual(jAXBElement, jAXBElement2)) {
            return true;
        }
        if (jAXBElement == null || jAXBElement2 == null) {
            return false;
        }
        return EqualsHelper.equals((Object)jAXBElement.getDeclaredType(), (Object)jAXBElement2.getDeclaredType()) && EqualsHelper.equals((Object)jAXBElement.getName(), (Object)jAXBElement2.getName()) && EqualsHelper.equals((Object)jAXBElement.getScope(), (Object)jAXBElement2.getScope()) && EqualsHelper.equals((boolean)jAXBElement.isNil(), (boolean)jAXBElement2.isNil()) && JAXBHelper._anyEquals(jAXBElement.getValue(), jAXBElement2.getValue());
    }

    public static boolean equalDOMNodes(@Nullable Node node, @Nullable Node node2) {
        if (EqualsHelper.identityEqual((Object)node, (Object)node2)) {
            return true;
        }
        if (node == null || node2 == null) {
            return false;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!EqualsHelper.equals((Object)node.getNodeName(), (Object)node2.getNodeName())) {
            return false;
        }
        if (!EqualsHelper.equals((Object)node.getLocalName(), (Object)node2.getLocalName())) {
            return false;
        }
        if (!EqualsHelper.equals((Object)node.getNamespaceURI(), (Object)node2.getNamespaceURI())) {
            return false;
        }
        if (!EqualsHelper.equals((Object)node.getPrefix(), (Object)node2.getPrefix())) {
            return false;
        }
        if (!EqualsHelper.equals((Object)node.getNodeValue(), (Object)node2.getNodeValue())) {
            return false;
        }
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        int n = nodeList.getLength();
        if (n != nodeList2.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Node node3;
            Node node4 = nodeList.item(i);
            if (JAXBHelper.equalDOMNodes(node4, node3 = nodeList2.item(i))) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean _listEquals(@Nullable List<T> list, @Nullable List<T> list2, @NonNull BiPredicate<T, T> biPredicate) {
        if (EqualsHelper.identityEqual(list, list2)) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        int n = list.size();
        if (n != list2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (biPredicate.test(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalListJAXBElements(@Nullable List<JAXBElement<?>> list, @Nullable List<JAXBElement<?>> list2) {
        return JAXBHelper._listEquals(list, list2, JAXBHelper::equalJAXBElements);
    }

    public static boolean equalListAnys(@Nullable List<Object> list, @Nullable List<Object> list2) {
        return JAXBHelper._listEquals(list, list2, JAXBHelper::_anyEquals);
    }

    private static int _getAnyHashCode(@Nullable Object object) {
        if (object == null) {
            return 129;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Arrays.hashCode(byArray);
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return JAXBHelper.getHashCode(node);
        }
        if (object instanceof JAXBElement) {
            JAXBElement jAXBElement = (JAXBElement)object;
            return JAXBHelper.getHashCode(jAXBElement);
        }
        if (object instanceof List) {
            return JAXBHelper.getListAnyHashCode((List)GenericReflection.uncheckedCast((Object)object));
        }
        return HashCodeCalculator.hashCode((Object)object);
    }

    public static int getHashCode(@Nullable JAXBElement<?> jAXBElement) {
        if (jAXBElement == null) {
            return 129;
        }
        return new HashCodeGenerator(jAXBElement.getClass()).append((Object)jAXBElement.getDeclaredType()).append((Object)jAXBElement.getName()).append((Object)jAXBElement.getScope()).append(jAXBElement.isNil()).append(JAXBHelper._getAnyHashCode(jAXBElement.getValue())).getHashCode();
    }

    public static int getHashCode(@Nullable Node node) {
        if (node == null) {
            return 129;
        }
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(node.getClass()).append(node.getNodeType()).append((Object)node.getNodeName()).append((Object)node.getLocalName()).append((Object)node.getNamespaceURI()).append((Object)node.getPrefix()).append((Object)node.getNodeValue());
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        hashCodeGenerator = hashCodeGenerator.append(n);
        for (int i = 0; i < n; ++i) {
            hashCodeGenerator = hashCodeGenerator.append(JAXBHelper.getHashCode(nodeList.item(i)));
        }
        return hashCodeGenerator.getHashCode();
    }

    private static <T> int _listHashCode(@Nullable List<T> list, @NonNull ToIntFunction<T> toIntFunction) {
        if (list == null) {
            return 129;
        }
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(list.getClass());
        for (T t : list) {
            hashCodeGenerator.append(toIntFunction.applyAsInt(t));
        }
        return hashCodeGenerator.getHashCode();
    }

    public static int getListJAXBElementHashCode(@Nullable List<JAXBElement<?>> list) {
        return JAXBHelper._listHashCode(list, JAXBHelper::getHashCode);
    }

    public static int getListAnyHashCode(@Nullable List<Object> list) {
        return JAXBHelper._listHashCode(list, JAXBHelper::_getAnyHashCode);
    }

    public static <DATATYPE> @Nullable JAXBElement<DATATYPE> getClonedJAXBElement(@Nullable JAXBElement<DATATYPE> jAXBElement) {
        if (jAXBElement == null) {
            return null;
        }
        Object object = CloneHelper.getClonedValue((Object)jAXBElement.getValue());
        JAXBElement jAXBElement2 = new JAXBElement(jAXBElement.getName(), jAXBElement.getDeclaredType(), jAXBElement.getScope(), object);
        jAXBElement2.setNil(jAXBElement.isNil());
        return jAXBElement2;
    }
}

