/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.web.PDTWebDateHelper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterOffsetDateTime
extends XmlAdapter<String, OffsetDateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterOffsetDateTime.class);
    private static Function<LocalDateTime, ZoneOffset> s_aZOSupplier = localDateTime -> ZoneOffset.UTC;

    public static @NonNull Function<LocalDateTime, ZoneOffset> getFallbackZoneOffsetSupplier() {
        return s_aZOSupplier;
    }

    public static void setFallbackZoneOffsetSupplier(@NonNull Function<LocalDateTime, ZoneOffset> function) {
        ValueEnforcer.notNull(function, (String)"ZoneOffsetSupplier");
        s_aZOSupplier = function;
    }

    public OffsetDateTime unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetDateTime offsetDateTime = PDTWebDateHelper.getOffsetDateTimeFromXSD((String)string2);
        if (offsetDateTime == null) {
            LocalDateTime localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD((String)string2);
            if (localDateTime != null) {
                offsetDateTime = OffsetDateTime.of(localDateTime, AdapterOffsetDateTime.getFallbackZoneOffsetSupplier().apply(localDateTime));
            } else {
                LOGGER.warn("Failed to parse '" + string + "' to an OffsetDateTime");
            }
        }
        return offsetDateTime;
    }

    public String marshal(@Nullable OffsetDateTime offsetDateTime) {
        return PDTWebDateHelper.getAsStringXSD((OffsetDateTime)offsetDateTime);
    }
}

