/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resourceprovider;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.EAppend;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.IWritableResource;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import com.helger.io.resourceprovider.IWritableResourceProvider;
import com.helger.io.resourceprovider.ReadableResourceProviderChain;
import java.io.OutputStream;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class WritableResourceProviderChain
extends ReadableResourceProviderChain
implements IWritableResourceProvider {
    protected final ICommonsList<IWritableResourceProvider> m_aWritableResourceProviders = new CommonsArrayList();

    public WritableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        super(iReadableResourceProviderArray);
        for (IReadableResourceProvider iReadableResourceProvider : iReadableResourceProviderArray) {
            if (!(iReadableResourceProvider instanceof IWritableResourceProvider)) continue;
            IWritableResourceProvider iWritableResourceProvider = (IWritableResourceProvider)iReadableResourceProvider;
            this.m_aWritableResourceProviders.add((Object)iWritableResourceProvider);
        }
        if (this.m_aWritableResourceProviders.isEmpty()) {
            throw new IllegalArgumentException("No writable resource provider passed - use a ReadableResourceProviderChain");
        }
    }

    public WritableResourceProviderChain(@NonNull Iterable<? extends IReadableResourceProvider> iterable) {
        super(iterable);
        for (IReadableResourceProvider iReadableResourceProvider : iterable) {
            if (!(iReadableResourceProvider instanceof IWritableResourceProvider)) continue;
            IWritableResourceProvider iWritableResourceProvider = (IWritableResourceProvider)iReadableResourceProvider;
            this.m_aWritableResourceProviders.add((Object)iWritableResourceProvider);
        }
        if (this.m_aWritableResourceProviders.isEmpty()) {
            throw new IllegalArgumentException("No writable resource provider passed - use a ReadableResourceProviderChain");
        }
    }

    @Nonempty
    @ReturnsMutableCopy
    public @NonNull ICommonsList<IWritableResourceProvider> getAllContainedWritingResourceProviders() {
        return (ICommonsList)this.m_aWritableResourceProviders.getClone();
    }

    @Override
    public final boolean supportsWriting(@Nullable String string) {
        return this.m_aWritableResourceProviders.containsAny(iWritableResourceProvider -> iWritableResourceProvider.supportsWriting(string));
    }

    @Override
    @OverrideOnDemand
    public @NonNull IWritableResource getWritableResource(@NonNull String string) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            if (!iWritableResourceProvider.supportsWriting(string)) continue;
            return iWritableResourceProvider.getWritableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle writing '" + string + "' by any of " + String.valueOf(this.m_aWritableResourceProviders));
    }

    public @Nullable IWritableResource getWritableResourceIf(@NonNull String string, @NonNull Predicate<? super IWritableResource> predicate) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            IWritableResource iWritableResource;
            if (!iWritableResourceProvider.supportsWriting(string) || !predicate.test(iWritableResource = iWritableResourceProvider.getWritableResource(string))) continue;
            return iWritableResource;
        }
        return null;
    }

    @Override
    public @Nullable OutputStream getOutputStream(@NonNull String string, @NonNull EAppend eAppend) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            OutputStream outputStream = iWritableResourceProvider.getOutputStream(string, eAppend);
            if (outputStream == null) continue;
            return outputStream;
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        WritableResourceProviderChain writableResourceProviderChain = (WritableResourceProviderChain)object;
        return this.m_aWritableResourceProviders.equals(writableResourceProviderChain.m_aWritableResourceProviders);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aWritableResourceProviders).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("writableResProviders", this.m_aWritableResourceProviders).getToString();
    }
}

