/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.misc;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public final class SizeHelper {
    public static final String B_SUFFIX = "B";
    public static final String KB_SUFFIX = "KB";
    public static final String MB_SUFFIX = "MB";
    public static final String GB_SUFFIX = "GB";
    public static final String TB_SUFFIX = "TB";
    public static final String PB_SUFFIX = "PB";
    private final DecimalFormatSymbols m_aDFS;
    private DecimalFormat m_aDF0;
    private DecimalFormat m_aDF1;
    private DecimalFormat m_aDF2;

    public SizeHelper(@NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.m_aDFS = DecimalFormatSymbols.getInstance(locale);
    }

    public SizeHelper(@NonNull DecimalFormatSymbols decimalFormatSymbols) {
        this.m_aDFS = (DecimalFormatSymbols)ValueEnforcer.notNull((Object)decimalFormatSymbols, (String)"DecimalFormatSymbols");
    }

    private @NonNull String _format(long l) {
        if (this.m_aDF0 == null) {
            this.m_aDF0 = new DecimalFormat("0", this.m_aDFS);
        }
        return this.m_aDF0.format(l);
    }

    private @NonNull String _format(double d, @Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Decimals");
        if (n == 0) {
            return this._format((long)d);
        }
        if (n == 1) {
            if (this.m_aDF1 == null) {
                this.m_aDF1 = new DecimalFormat("0.0", this.m_aDFS);
            }
            return this.m_aDF1.format(d);
        }
        if (n == 2) {
            if (this.m_aDF2 == null) {
                this.m_aDF2 = new DecimalFormat("0.00", this.m_aDFS);
            }
            return this.m_aDF2.format(d);
        }
        StringBuilder stringBuilder = new StringBuilder("0.000");
        for (int i = 3; i < n; ++i) {
            stringBuilder.append('0');
        }
        return new DecimalFormat(stringBuilder.toString(), this.m_aDFS).format(d);
    }

    public @NonNull String getAsKB(long l) {
        return this._format(l / 1024L) + KB_SUFFIX;
    }

    public @NonNull String getAsKB(long l, @Nonnegative int n) {
        return this._format((double)l / 1024.0, n) + KB_SUFFIX;
    }

    public @NonNull String getAsMB(long l) {
        return this._format(l / 0x100000L) + MB_SUFFIX;
    }

    public @NonNull String getAsMB(long l, @Nonnegative int n) {
        return this._format((double)l / 1048576.0, n) + MB_SUFFIX;
    }

    public @NonNull String getAsGB(long l) {
        return this._format(l / 0x40000000L) + GB_SUFFIX;
    }

    public @NonNull String getAsGB(long l, @Nonnegative int n) {
        return this._format((double)l / 1.073741824E9, n) + GB_SUFFIX;
    }

    public @NonNull String getAsTB(long l) {
        return this._format(l / 0x10000000000L) + TB_SUFFIX;
    }

    public @NonNull String getAsTB(long l, @Nonnegative int n) {
        return this._format((double)l / 1.099511627776E12, n) + TB_SUFFIX;
    }

    public @NonNull String getAsPB(long l) {
        return this._format(l / 0x4000000000000L) + PB_SUFFIX;
    }

    public @NonNull String getAsPB(long l, @Nonnegative int n) {
        return this._format((double)l / 1.125899906842624E15, n) + PB_SUFFIX;
    }

    private static void _checkConvertibility(@NonNull BigInteger bigInteger) {
        if (bigInteger.compareTo(CGlobal.BIGINT_MAX_LONG) > 0) {
            throw new IllegalArgumentException("The passed BigInteger is too large to be converted into a long value: " + bigInteger.toString());
        }
        if (bigInteger.compareTo(CGlobal.BIGINT_MIN_LONG) < 0) {
            throw new IllegalArgumentException("The passed BigInteger is too small to be converted into a long value: " + bigInteger.toString());
        }
    }

    public @NonNull String getAsMatching(@NonNull BigInteger bigInteger) {
        SizeHelper._checkConvertibility(bigInteger);
        return this.getAsMatching(bigInteger.longValue());
    }

    public @NonNull String getAsMatching(@NonNull BigInteger bigInteger, @Nonnegative int n) {
        SizeHelper._checkConvertibility(bigInteger);
        return this.getAsMatching(bigInteger.longValue(), n);
    }

    private static void _checkConvertibility(@NonNull BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(CGlobal.BIGDEC_MAX_LONG) > 0) {
            throw new IllegalArgumentException("The passed BigDecimal is too large to be converted into a long value: " + bigDecimal.toString());
        }
        if (bigDecimal.compareTo(CGlobal.BIGDEC_MIN_LONG) < 0) {
            throw new IllegalArgumentException("The passed BigDecimal is too small to be converted into a long value: " + bigDecimal.toString());
        }
    }

    public @NonNull String getAsMatching(@NonNull BigDecimal bigDecimal) {
        SizeHelper._checkConvertibility(bigDecimal);
        return this.getAsMatching(bigDecimal.longValue());
    }

    public @NonNull String getAsMatching(@NonNull BigDecimal bigDecimal, @Nonnegative int n) {
        SizeHelper._checkConvertibility(bigDecimal);
        return this.getAsMatching(bigDecimal.longValue(), n);
    }

    public @NonNull String getAsMatching(long l) {
        if (l >= 0x4000000000000L) {
            return this.getAsPB(l);
        }
        if (l >= 0x10000000000L) {
            return this.getAsTB(l);
        }
        if (l >= 0x40000000L) {
            return this.getAsGB(l);
        }
        if (l >= 0x100000L) {
            return this.getAsMB(l);
        }
        if (l >= 1024L) {
            return this.getAsKB(l);
        }
        return this._format(l) + B_SUFFIX;
    }

    public @NonNull String getAsMatching(long l, @Nonnegative int n) {
        if (l >= 0x4000000000000L) {
            return this.getAsPB(l, n);
        }
        if (l >= 0x10000000000L) {
            return this.getAsTB(l, n);
        }
        if (l >= 0x40000000L) {
            return this.getAsGB(l, n);
        }
        if (l >= 0x100000L) {
            return this.getAsMB(l, n);
        }
        if (l >= 1024L) {
            return this.getAsKB(l, n);
        }
        return this._format(l, n) + B_SUFFIX;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("dfs", (Object)this.m_aDFS).getToString();
    }

    public static @NonNull SizeHelper getSizeHelperOfLocale(@NonNull Locale locale) {
        return new SizeHelper(locale);
    }
}

