/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.Nonempty;
import com.helger.cache.regex.RegExHelper;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FilenameHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IFileFilter
extends FileFilter,
FilenameFilter,
Predicate<File> {
    @Override
    default public boolean accept(@Nullable File file) {
        return this.test(file);
    }

    @Override
    default public boolean accept(@Nullable File file, @Nullable String string) {
        if (string == null) {
            return false;
        }
        File file2 = file != null ? new File(file, string) : new File(string);
        return this.test(file2);
    }

    public static @NonNull IFileFilter directoryOnly() {
        return FileHelper::existsDir;
    }

    public static @NonNull IFileFilter directoryPublic() {
        return file -> FileHelper.existsDir(file) && !FilenameHelper.isHiddenFilename(file);
    }

    public static @NonNull IFileFilter parentDirectoryPublic() {
        return file -> {
            File file2 = file != null ? file.getAbsoluteFile().getParentFile() : null;
            return file2 != null && !FilenameHelper.isHiddenFilename(file2);
        };
    }

    public static @NonNull IFileFilter fileOnly() {
        return FileHelper::existsFile;
    }

    public static @NonNull IFileFilter filenameHidden() {
        return FilenameHelper::isHiddenFilename;
    }

    public static @NonNull IFileFilter filenameStartsWith(@Nonempty @NonNull String string) {
        Objects.requireNonNull(string);
        return file -> {
            String string2;
            if (file != null && (string2 = FilenameHelper.getSecureFilename(file.getName())) != null) {
                return string2.startsWith(string);
            }
            return false;
        };
    }

    public static @NonNull IFileFilter filenameEndsWith(@Nonempty @NonNull String string) {
        Objects.requireNonNull(string);
        return file -> {
            String string2;
            if (file != null && (string2 = FilenameHelper.getSecureFilename(file.getName())) != null) {
                return string2.endsWith(string);
            }
            return false;
        };
    }

    public static @NonNull IFileFilter filenameEquals(@Nonempty @NonNull String string) {
        Objects.requireNonNull(string);
        return file -> file != null && string.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    public static @NonNull IFileFilter filenameEqualsIgnoreCase(@Nonempty @NonNull String string) {
        Objects.requireNonNull(string);
        return file -> file != null && string.equalsIgnoreCase(FilenameHelper.getSecureFilename(file.getName()));
    }

    public static @NonNull IFileFilter filenameNotEquals(@Nonempty @NonNull String string) {
        Objects.requireNonNull(string);
        return file -> file != null && !string.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    public static @NonNull IFileFilter filenameNotEqualsIgnoreCase(@Nonempty @NonNull String string) {
        Objects.requireNonNull(string);
        return file -> file != null && !string.equalsIgnoreCase(FilenameHelper.getSecureFilename(file.getName()));
    }

    public static @NonNull IFileFilter filenameMatchAnyRegEx(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            String string;
            if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
                for (String string2 : stringArray) {
                    if (!RegExHelper.stringMatchesPattern((String)string2, (String)string)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static @NonNull IFileFilter filenameMatchNoRegEx(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            if (file == null) {
                return false;
            }
            String string = FilenameHelper.getSecureFilename(file.getName());
            if (string == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!RegExHelper.stringMatchesPattern((String)string2, (String)string)) continue;
                return false;
            }
            return true;
        };
    }

    public static @NonNull IFileFilter filenameMatchAny(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            String string;
            if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static @NonNull IFileFilter filenameMatchNone(String ... stringArray) {
        Objects.requireNonNull(stringArray);
        return file -> {
            if (file == null) {
                return false;
            }
            String string = FilenameHelper.getSecureFilename(file.getName());
            if (string == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                return false;
            }
            return true;
        };
    }
}

