/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error.level;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.id.IHasID;
import com.helger.base.state.IErrorIndicator;
import com.helger.base.state.ISuccessIndicator;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.severity.ISeverityComparable;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface IErrorLevel
extends IHasID<String>,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<IErrorLevel> {
    @Nonnegative
    public int getNumericLevel();

    default public boolean isSuccess() {
        return this.isEQ(EErrorLevel.SUCCESS);
    }

    default public boolean isFailure() {
        return this.isGT(EErrorLevel.SUCCESS);
    }

    default public boolean isError() {
        return this.isGE(EErrorLevel.ERROR);
    }

    default public boolean isNoError() {
        return this.isLT(EErrorLevel.ERROR);
    }

    default public int compareTo(@NonNull IErrorLevel iErrorLevel) {
        return Integer.compare(this.getNumericLevel(), iErrorLevel.getNumericLevel());
    }

    @Override
    default public boolean isEQ(@NonNull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() == iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isNE(@NonNull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() != iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isLT(@NonNull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() < iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isLE(@NonNull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() <= iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isGT(@NonNull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() > iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isGE(@NonNull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() >= iErrorLevel.getNumericLevel();
    }

    default public boolean isHighest() {
        return this.isEQ(EErrorLevel.HIGHEST);
    }

    public static @Nullable IErrorLevel getMostSevere(@Nullable IErrorLevel iErrorLevel, @Nullable IErrorLevel iErrorLevel2) {
        if (EqualsHelper.identityEqual((Object)iErrorLevel, (Object)iErrorLevel2)) {
            return iErrorLevel;
        }
        if (iErrorLevel == null) {
            return iErrorLevel2;
        }
        if (iErrorLevel2 == null) {
            return iErrorLevel;
        }
        return iErrorLevel.isGT(iErrorLevel2) ? iErrorLevel : iErrorLevel2;
    }
}

