/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao;

import com.helger.annotation.Nonnegative;
import com.helger.dao.DAOException;
import com.helger.dao.IAutoSaveAware;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public interface IDAO
extends IAutoSaveAware {
    public boolean hasPendingChanges();

    public void writeToFileOnPendingChanges();

    @Nonnegative
    public int getInitCount();

    @Nullable
    public LocalDateTime getLastInitDateTime();

    @Nonnegative
    public int getReadCount();

    @Nullable
    public LocalDateTime getLastReadDateTime();

    @Nonnegative
    public int getWriteCount();

    @Nullable
    public LocalDateTime getLastWriteDateTime();

    default public boolean isReloadable() {
        return false;
    }

    default public void reload() throws DAOException {
        if (this.isReloadable()) {
            throw new UnsupportedOperationException("Reloadable is specified, but 'reload' is not implemented!");
        }
        throw new UnsupportedOperationException("This class is not reloadable. Call this method only if 'isReloadable' returns true!");
    }

    public static enum EMode {
        READ,
        WRITE;

    }
}

