/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.envvar;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import org.jspecify.annotations.NonNull;

@Immutable
public final class EnvVarHelper {
    public static final char DEFAULT_REPLACEMENT_CHAR = '_';
    public static final char REPLACEMENT_CHAR_TO_SKIP = '\u0000';

    private EnvVarHelper() {
    }

    public static boolean isValidFirstChar(char c) {
        return c >= 'A' && c <= 'Z' || c == '_';
    }

    public static boolean isValidFollowingChar(char c) {
        return EnvVarHelper.isValidFirstChar(c) || c >= '0' && c <= '9';
    }

    public static @NonNull String getUnifiedSysEnvName(@Nonempty @NonNull String string, char c) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        for (char c2 : string.toCharArray()) {
            boolean bl;
            char c3 = Character.toUpperCase(c2);
            boolean bl2 = bl = n == 0 ? EnvVarHelper.isValidFirstChar(c3) : EnvVarHelper.isValidFollowingChar(c3);
            if (bl) {
                stringBuilder.append(c3);
            } else if (c != '\u0000') {
                stringBuilder.append(c);
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

