/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.graph;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.graph.IBaseGraph;
import com.helger.graph.IBaseGraphNode;
import com.helger.graph.IBaseGraphRelation;
import com.helger.graph.IDirectedGraph;
import com.helger.graph.IDirectedGraphNode;
import com.helger.graph.IDirectedGraphRelation;
import com.helger.xml.serialize.write.EXMLCharMode;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.XMLMaskHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

@Immutable
public final class GraphVizHelper {
    private GraphVizHelper() {
    }

    @Nonnull
    @Nonempty
    public static String getAttribute(@Nonnull @Nonempty String string, @Nonnull String string2) {
        return string + "=<" + XMLMaskHelper.getMaskedXMLText((EXMLSerializeVersion)EXMLSerializeVersion.XML_10, (EXMLCharMode)EXMLCharMode.ELEMENT_NAME, (EXMLIncorrectCharacterHandling)EXMLIncorrectCharacterHandling.DEFAULT, (String)string2) + '>';
    }

    @Nonnull
    public static <N extends IBaseGraphNode<N, R>, R extends IBaseGraphRelation<N, R>> String getAsGraphVizDot(@Nonnull IBaseGraph<N, R> iBaseGraph, @Nullable String string, @Nullable String string2) {
        ValueEnforcer.notNull(iBaseGraph, (String)"Graph");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("graph ").append((String)iBaseGraph.getID()).append("{\n");
        stringBuilder.append("node[shape=box];");
        iBaseGraph.forEachNode(iBaseGraphNode -> {
            stringBuilder.append((String)iBaseGraphNode.getID());
            if (StringHelper.isNotEmpty((String)string)) {
                String string2 = iBaseGraphNode.attrs().getAsString((Object)string);
                stringBuilder.append('[').append(GraphVizHelper.getAttribute("label", string2)).append(']');
            }
            stringBuilder.append(';');
        });
        stringBuilder.append('\n');
        iBaseGraph.forEachRelation(iBaseGraphRelation -> {
            Iterator iterator = iBaseGraphRelation.getAllConnectedNodes().iterator();
            stringBuilder.append((String)((IBaseGraphNode)iterator.next()).getID()).append("--").append((String)((IBaseGraphNode)iterator.next()).getID());
            if (StringHelper.isNotEmpty((String)string2)) {
                String string2 = iBaseGraphRelation.attrs().getAsString((Object)string2);
                stringBuilder.append('[').append(GraphVizHelper.getAttribute("label", string2)).append(']');
            }
            stringBuilder.append(";\n");
        });
        stringBuilder.append("overlap=false;\n");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Nonnull
    public static <N extends IDirectedGraphNode<N, R>, R extends IDirectedGraphRelation<N, R>> String getAsGraphVizDot(@Nonnull IDirectedGraph<N, R> iDirectedGraph, @Nullable String string, @Nullable String string2) {
        ValueEnforcer.notNull(iDirectedGraph, (String)"Graph");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph ").append((String)iDirectedGraph.getID()).append("{\n");
        stringBuilder.append("node[shape=box];");
        iDirectedGraph.forEachNode(iDirectedGraphNode -> {
            stringBuilder.append((String)iDirectedGraphNode.getID());
            if (StringHelper.isNotEmpty((String)string)) {
                String string2 = iDirectedGraphNode.attrs().getAsString((Object)string);
                stringBuilder.append("[label=<").append(XMLMaskHelper.getMaskedXMLText((EXMLSerializeVersion)EXMLSerializeVersion.XML_10, (EXMLCharMode)EXMLCharMode.ELEMENT_NAME, (EXMLIncorrectCharacterHandling)EXMLIncorrectCharacterHandling.DEFAULT, (String)string2)).append(">]");
            }
            stringBuilder.append(';');
        });
        stringBuilder.append('\n');
        iDirectedGraph.forEachRelation(iDirectedGraphRelation -> {
            stringBuilder.append(iDirectedGraphRelation.getFromID()).append("->").append(iDirectedGraphRelation.getToID());
            if (StringHelper.isNotEmpty((String)string2)) {
                String string2 = iDirectedGraphRelation.attrs().getAsString((Object)string2);
                stringBuilder.append("[label=<").append(XMLMaskHelper.getMaskedXMLText((EXMLSerializeVersion)EXMLSerializeVersion.XML_10, (EXMLCharMode)EXMLCharMode.ELEMENT_NAME, (EXMLIncorrectCharacterHandling)EXMLIncorrectCharacterHandling.DEFAULT, (String)string2)).append(">]");
            }
            stringBuilder.append(";\n");
        });
        stringBuilder.append("overlap=false;\n");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getGraphAsImageWithGraphVizNeato(@Nonnull @Nonempty String string, @Nonnull String string2) throws IOException, InterruptedException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FileType");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DOT");
        ProcessBuilder processBuilder = new ProcessBuilder("neato", "-T" + string).redirectErrorStream(false);
        Process process = processBuilder.start();
        process.getOutputStream().write(string2.getBytes(StandardCharsets.UTF_8));
        process.getOutputStream().close();
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        StreamHelper.copyInputStreamToOutputStream((InputStream)process.getInputStream(), (OutputStream)nonBlockingByteArrayOutputStream);
        process.waitFor();
        return nonBlockingByteArrayOutputStream;
    }
}

