/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.cache.Cache;
import com.helger.commons.datetime.DateTimeFormatterPattern;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DateTimeFormatterCache
extends Cache<DateTimeFormatterPattern, DateTimeFormatter> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean s_bDefaultInstantiated = false;

    private DateTimeFormatterCache() {
        super(DateTimeFormatterPattern::getAsFormatter, 1000, DateTimeFormatterCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static DateTimeFormatterCache getInstance() {
        DateTimeFormatterCache dateTimeFormatterCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return dateTimeFormatterCache;
    }

    @Nonnull
    public static DateTimeFormatter getDateTimeFormatterStrict(@Nonnull @Nonempty String string) {
        return DateTimeFormatterCache.getDateTimeFormatter(string, ResolverStyle.STRICT);
    }

    @Nonnull
    public static DateTimeFormatter getDateTimeFormatterSmart(@Nonnull @Nonempty String string) {
        return DateTimeFormatterCache.getDateTimeFormatter(string, ResolverStyle.SMART);
    }

    @Nonnull
    public static DateTimeFormatter getDateTimeFormatterLenient(@Nonnull @Nonempty String string) {
        return DateTimeFormatterCache.getDateTimeFormatter(string, ResolverStyle.LENIENT);
    }

    @Nonnull
    public static DateTimeFormatter getDateTimeFormatter(@Nonnull @Nonempty String string, @Nonnull ResolverStyle resolverStyle) {
        return (DateTimeFormatter)DateTimeFormatterCache.getInstance().getFromCache(new DateTimeFormatterPattern(string, resolverStyle));
    }

    private static final class SingletonHolder {
        private static final DateTimeFormatterCache INSTANCE = new DateTimeFormatterCache();

        private SingletonHolder() {
        }
    }
}

