/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsCollection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsSet<ELEMENTTYPE>
extends Set<ELEMENTTYPE>,
ICommonsCollection<ELEMENTTYPE>,
ICloneable<ICommonsSet<ELEMENTTYPE>> {
    @ReturnsMutableCopy
    default public <T> @NonNull ICommonsSet<T> createInstance() {
        return new CommonsHashSet();
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsSet<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return (ICommonsSet)this.getClone();
        }
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAll(predicate, iCommonsSet::add);
        return iCommonsSet;
    }

    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsSet<DSTTYPE> getAllMapped(@NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(function, iCommonsSet::add);
        return iCommonsSet;
    }

    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsSet<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(predicate, function, iCommonsSet::add);
        return iCommonsSet;
    }

    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> @NonNull ICommonsSet<DSTTYPE> getAllInstanceOf(@NonNull Class<DSTTYPE> clazz) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllInstanceOf(clazz, iCommonsSet::add);
        return iCommonsSet;
    }

    default public boolean replace(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        boolean bl = this.remove(ELEMENTTYPE);
        this.add(ELEMENTTYPE);
        return bl;
    }

    @Override
    @CodingStyleguideUnaware
    default public @NonNull Set<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableSet(this);
    }
}

