/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.state;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.ESuccess;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.wrapper.IWrapper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class SuccessWithValue<DATATYPE>
implements ISuccessIndicator,
IWrapper<DATATYPE> {
    private final ESuccess m_eSuccess;
    private final DATATYPE m_aObj;

    public SuccessWithValue(@NonNull ISuccessIndicator iSuccessIndicator) {
        this(iSuccessIndicator, null);
    }

    public SuccessWithValue(@NonNull ISuccessIndicator iSuccessIndicator, @Nullable DATATYPE DATATYPE) {
        ValueEnforcer.notNull(iSuccessIndicator, "SuccessIndicator");
        this.m_eSuccess = ESuccess.valueOf(iSuccessIndicator);
        this.m_aObj = DATATYPE;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eSuccess.isSuccess();
    }

    @Override
    public @Nullable DATATYPE get() {
        return this.m_aObj;
    }

    public @Nullable DATATYPE getIfSuccess(@Nullable DATATYPE DATATYPE) {
        return this.m_eSuccess.isSuccess() ? this.m_aObj : DATATYPE;
    }

    public @Nullable DATATYPE getIfSuccessOrNull() {
        return this.getIfSuccess(null);
    }

    public @Nullable DATATYPE getIfFailure(@Nullable DATATYPE DATATYPE) {
        return this.m_eSuccess.isFailure() ? this.m_aObj : DATATYPE;
    }

    public @Nullable DATATYPE getIfFailureOrNull() {
        return this.getIfFailure(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SuccessWithValue successWithValue = (SuccessWithValue)object;
        return this.m_eSuccess.equals(successWithValue.m_eSuccess) && EqualsHelper.equals(this.m_aObj, successWithValue.m_aObj);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_eSuccess).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("success", this.m_eSuccess).append("obj", this.m_aObj).getToString();
    }

    public static <DATATYPE> @NonNull SuccessWithValue<DATATYPE> create(@NonNull ISuccessIndicator iSuccessIndicator, @Nullable DATATYPE DATATYPE) {
        return new SuccessWithValue<DATATYPE>(iSuccessIndicator, DATATYPE);
    }

    public static <DATATYPE> @NonNull SuccessWithValue<DATATYPE> createSuccess(@Nullable DATATYPE DATATYPE) {
        return new SuccessWithValue<DATATYPE>(ESuccess.SUCCESS, DATATYPE);
    }

    public static <DATATYPE> @NonNull SuccessWithValue<DATATYPE> createFailure(@Nullable DATATYPE DATATYPE) {
        return new SuccessWithValue<DATATYPE>(ESuccess.FAILURE, DATATYPE);
    }
}

