/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.IByteArrayStreamDecoder;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class RunLengthCodec
implements IByteArrayStreamDecoder {
    protected static final int RUN_LENGTH_EOD = 128;

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, n2);){
            int n3;
            byte[] byArray2 = new byte[128];
            while ((n3 = nonBlockingByteArrayInputStream.read()) != -1 && n3 != 128) {
                int n4;
                int n5;
                if (n3 <= 127) {
                    for (n4 = n3; n4 > 0; n4 -= n5) {
                        n5 = nonBlockingByteArrayInputStream.read(byArray2, 0, n4);
                        if (n5 < 0) {
                            throw new DecodeException("Unexpected EOF in RunLengthCodec - " + n4 + " elements left");
                        }
                        outputStream.write(byArray2, 0, n5);
                    }
                    continue;
                }
                n4 = nonBlockingByteArrayInputStream.read();
                if (n4 == -1) {
                    throw new DecodeException("Unexpected EOF in RunLengthCodec");
                }
                for (n5 = 0; n5 < 257 - n3; ++n5) {
                    outputStream.write(n4);
                }
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode RunLength", iOException);
        }
    }
}

