/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.email;

import com.helger.base.name.IHasDisplayName;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public interface IEmailAddress
extends IHasDisplayName {
    @Nonnull
    public String getAddress();

    @Nullable
    public String getPersonal();

    default public boolean hasPersonal() {
        return StringHelper.isNotEmpty(this.getPersonal());
    }

    @Override
    @Nonnull
    default public String getDisplayName() {
        if (this.hasPersonal()) {
            return this.getPersonal() + " <" + this.getAddress() + ">";
        }
        return this.getAddress();
    }
}

