/*
 * Decompiled with CFR 0.152.
 */
package com.hbb20;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.os.Build;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import com.hbb20.CCPCountry;
import com.hbb20.CCPCountryGroup;
import com.hbb20.CCPTalkBackTextProvider;
import com.hbb20.CountryCodeDialog;
import com.hbb20.InternalTalkBackTextProvider;
import com.hbb20.InternationalPhoneTextWatcher;
import com.hbb20.R;
import io.michaelrocks.libphonenumber.android.NumberParseException;
import io.michaelrocks.libphonenumber.android.PhoneNumberUtil;
import io.michaelrocks.libphonenumber.android.Phonenumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CountryCodePicker
extends RelativeLayout {
    static final int DEFAULT_UNSET = -99;
    static String TAG = "CCP";
    static String BUNDLE_SELECTED_CODE = "selectedCode";
    static int LIB_DEFAULT_COUNTRY_CODE = 91;
    private static int TEXT_GRAVITY_LEFT = -1;
    private static int TEXT_GRAVITY_RIGHT = 1;
    private static int TEXT_GRAVITY_CENTER = 0;
    private static String ANDROID_NAME_SPACE = "http://schemas.android.com/apk/res/android";
    private CCPTalkBackTextProvider talkBackTextProvider = new InternalTalkBackTextProvider();
    String CCP_PREF_FILE = "CCP_PREF_FILE";
    int defaultCountryCode;
    String defaultCountryNameCode;
    Context context;
    View holderView;
    LayoutInflater mInflater;
    TextView textView_selectedCountry;
    EditText editText_registeredCarrierNumber;
    RelativeLayout holder;
    ImageView imageViewArrow;
    ImageView imageViewFlag;
    LinearLayout linearFlagBorder;
    LinearLayout linearFlagHolder;
    CCPCountry selectedCCPCountry;
    CCPCountry defaultCCPCountry;
    RelativeLayout relativeClickConsumer;
    CountryCodePicker codePicker;
    TextGravity currentTextGravity;
    String originalHint = "";
    int ccpPadding;
    AutoDetectionPref selectedAutoDetectionPref = AutoDetectionPref.SIM_NETWORK_LOCALE;
    PhoneNumberUtil phoneUtil;
    boolean rippleEnable = true;
    boolean showNameCode = true;
    boolean showPhoneCode = true;
    boolean ccpDialogShowPhoneCode = true;
    boolean showFlag = true;
    boolean showFullName = false;
    boolean showFastScroller = true;
    boolean ccpDialogShowTitle = true;
    boolean ccpDialogShowFlag = true;
    boolean ccpDialogRippleEnable = true;
    boolean searchAllowed = true;
    boolean showArrow = true;
    boolean showCloseIcon = false;
    boolean rememberLastSelection = false;
    boolean detectCountryWithAreaCode = true;
    boolean ccpDialogShowNameCode = true;
    boolean ccpDialogInitialScrollToSelection = false;
    boolean ccpUseEmoji = false;
    boolean ccpUseDummyEmojiForPreview = false;
    boolean internationalFormattingOnly = true;
    PhoneNumberType hintExampleNumberType = PhoneNumberType.MOBILE;
    String selectionMemoryTag = "ccp_last_selection";
    int contentColor = -99;
    int arrowColor = -99;
    int borderFlagColor;
    Typeface dialogTypeFace;
    int dialogTypeFaceStyle;
    List<CCPCountry> preferredCountries;
    int ccpTextgGravity = TEXT_GRAVITY_CENTER;
    String countryPreference;
    int fastScrollerBubbleColor = 0;
    List<CCPCountry> customMasterCountriesList;
    String customMasterCountriesParam;
    String excludedCountriesParam;
    Language customDefaultLanguage = Language.ENGLISH;
    Language languageToApply = Language.ENGLISH;
    boolean dialogKeyboardAutoPopup = true;
    boolean ccpClickable = true;
    boolean autoDetectLanguageEnabled = false;
    boolean autoDetectCountryEnabled = false;
    boolean numberAutoFormattingEnabled = true;
    boolean hintExampleNumberEnabled = false;
    String xmlWidth = "notSet";
    TextWatcher validityTextWatcher;
    InternationalPhoneTextWatcher formattingTextWatcher;
    boolean reportedValidity;
    TextWatcher areaCodeCountryDetectorTextWatcher;
    boolean countryDetectionBasedOnAreaAllowed;
    String lastCheckedAreaCode = null;
    int lastCursorPosition = 0;
    boolean countryChangedDueToAreaCode = false;
    private OnCountryChangeListener onCountryChangeListener;
    private PhoneNumberValidityChangeListener phoneNumberValidityChangeListener;
    private FailureListener failureListener;
    private DialogEventsListener dialogEventsListener;
    private CustomDialogTextProvider customDialogTextProvider;
    private int fastScrollerHandleColor = 0;
    private int dialogBackgroundResId;
    private int dialogBackgroundColor;
    private int dialogTextColor;
    private int dialogSearchEditTextTintColor;
    private int fastScrollerBubbleTextAppearance = 0;
    private float dialogCornerRadius;
    private CCPCountryGroup currentCountryGroup;
    private View.OnClickListener customClickListener;
    View.OnClickListener countryCodeHolderClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (CountryCodePicker.this.customClickListener == null) {
                if (CountryCodePicker.this.isCcpClickable()) {
                    if (CountryCodePicker.this.ccpDialogInitialScrollToSelection) {
                        CountryCodePicker.this.launchCountrySelectionDialog(CountryCodePicker.this.getSelectedCountryNameCode());
                    } else {
                        CountryCodePicker.this.launchCountrySelectionDialog();
                    }
                }
            } else {
                CountryCodePicker.this.customClickListener.onClick(v);
            }
        }
    };

    public CountryCodePicker(Context context) {
        super(context);
        this.context = context;
        this.init(null);
    }

    public CountryCodePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    public CountryCodePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init(attrs);
    }

    private boolean isNumberAutoFormattingEnabled() {
        return this.numberAutoFormattingEnabled;
    }

    public void setNumberAutoFormattingEnabled(boolean numberAutoFormattingEnabled) {
        this.numberAutoFormattingEnabled = numberAutoFormattingEnabled;
        if (this.editText_registeredCarrierNumber != null) {
            this.updateFormattingTextWatcher();
        }
    }

    private boolean isInternationalFormattingOnlyEnabled() {
        return this.internationalFormattingOnly;
    }

    public void setInternationalFormattingOnly(boolean internationalFormattingOnly) {
        this.internationalFormattingOnly = internationalFormattingOnly;
        if (this.editText_registeredCarrierNumber != null) {
            this.updateFormattingTextWatcher();
        }
    }

    private void init(AttributeSet attrs) {
        this.mInflater = LayoutInflater.from((Context)this.context);
        if (attrs != null) {
            this.xmlWidth = attrs.getAttributeValue(ANDROID_NAME_SPACE, "layout_width");
        }
        this.removeAllViewsInLayout();
        this.holderView = attrs != null && this.xmlWidth != null && (this.xmlWidth.equals("-1") || this.xmlWidth.equals("-1") || this.xmlWidth.equals("fill_parent") || this.xmlWidth.equals("match_parent")) ? this.mInflater.inflate(R.layout.layout_full_width_code_picker, (ViewGroup)this, true) : this.mInflater.inflate(R.layout.layout_code_picker, (ViewGroup)this, true);
        this.textView_selectedCountry = (TextView)this.holderView.findViewById(R.id.textView_selectedCountry);
        this.holder = (RelativeLayout)this.holderView.findViewById(R.id.countryCodeHolder);
        this.imageViewArrow = (ImageView)this.holderView.findViewById(R.id.imageView_arrow);
        this.imageViewFlag = (ImageView)this.holderView.findViewById(R.id.image_flag);
        this.linearFlagHolder = (LinearLayout)this.holderView.findViewById(R.id.linear_flag_holder);
        this.linearFlagBorder = (LinearLayout)this.holderView.findViewById(R.id.linear_flag_border);
        this.relativeClickConsumer = (RelativeLayout)this.holderView.findViewById(R.id.rlClickConsumer);
        this.codePicker = this;
        if (attrs != null) {
            this.applyCustomProperty(attrs);
        }
        this.relativeClickConsumer.setOnClickListener(this.countryCodeHolderClickListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCustomProperty(AttributeSet attrs) {
        TypedArray a = this.context.getTheme().obtainStyledAttributes(attrs, R.styleable.CountryCodePicker, 0, 0);
        try {
            int arrowSize;
            int borderFlagColor;
            this.showNameCode = a.getBoolean(R.styleable.CountryCodePicker_ccp_showNameCode, true);
            this.numberAutoFormattingEnabled = a.getBoolean(R.styleable.CountryCodePicker_ccp_autoFormatNumber, true);
            this.showPhoneCode = a.getBoolean(R.styleable.CountryCodePicker_ccp_showPhoneCode, true);
            this.ccpDialogShowPhoneCode = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_showPhoneCode, this.showPhoneCode);
            this.ccpDialogShowNameCode = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_showNameCode, true);
            this.ccpDialogShowTitle = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_showTitle, true);
            this.ccpUseEmoji = a.getBoolean(R.styleable.CountryCodePicker_ccp_useFlagEmoji, false);
            this.ccpUseDummyEmojiForPreview = a.getBoolean(R.styleable.CountryCodePicker_ccp_useDummyEmojiForPreview, false);
            this.ccpDialogShowFlag = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_showFlag, true);
            this.ccpDialogInitialScrollToSelection = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_initialScrollToSelection, false);
            this.ccpDialogRippleEnable = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_rippleEnable, true);
            this.showFullName = a.getBoolean(R.styleable.CountryCodePicker_ccp_showFullName, false);
            this.showFastScroller = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_showFastScroller, true);
            this.fastScrollerBubbleColor = a.getColor(R.styleable.CountryCodePicker_ccpDialog_fastScroller_bubbleColor, 0);
            this.fastScrollerHandleColor = a.getColor(R.styleable.CountryCodePicker_ccpDialog_fastScroller_handleColor, 0);
            this.fastScrollerBubbleTextAppearance = a.getResourceId(R.styleable.CountryCodePicker_ccpDialog_fastScroller_bubbleTextAppearance, 0);
            this.autoDetectLanguageEnabled = a.getBoolean(R.styleable.CountryCodePicker_ccp_autoDetectLanguage, false);
            this.detectCountryWithAreaCode = a.getBoolean(R.styleable.CountryCodePicker_ccp_areaCodeDetectedCountry, true);
            this.rememberLastSelection = a.getBoolean(R.styleable.CountryCodePicker_ccp_rememberLastSelection, false);
            this.hintExampleNumberEnabled = a.getBoolean(R.styleable.CountryCodePicker_ccp_hintExampleNumber, false);
            this.internationalFormattingOnly = a.getBoolean(R.styleable.CountryCodePicker_ccp_internationalFormattingOnly, true);
            this.ccpPadding = (int)a.getDimension(R.styleable.CountryCodePicker_ccp_padding, this.context.getResources().getDimension(R.dimen.ccp_padding));
            this.relativeClickConsumer.setPadding(this.ccpPadding, this.ccpPadding, this.ccpPadding, this.ccpPadding);
            int hintNumberTypeIndex = a.getInt(R.styleable.CountryCodePicker_ccp_hintExampleNumberType, 0);
            this.hintExampleNumberType = PhoneNumberType.values()[hintNumberTypeIndex];
            this.selectionMemoryTag = a.getString(R.styleable.CountryCodePicker_ccp_selectionMemoryTag);
            if (this.selectionMemoryTag == null) {
                this.selectionMemoryTag = "CCP_last_selection";
            }
            int autoDetectionPrefValue = a.getInt(R.styleable.CountryCodePicker_ccp_countryAutoDetectionPref, 123);
            this.selectedAutoDetectionPref = AutoDetectionPref.getPrefForValue(String.valueOf(autoDetectionPrefValue));
            this.autoDetectCountryEnabled = a.getBoolean(R.styleable.CountryCodePicker_ccp_autoDetectCountry, false);
            this.showArrow = a.getBoolean(R.styleable.CountryCodePicker_ccp_showArrow, true);
            this.refreshArrowViewVisibility();
            this.showCloseIcon = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_showCloseIcon, false);
            this.rippleEnable = a.getBoolean(R.styleable.CountryCodePicker_ccp_rippleEnable, true);
            this.refreshEnableRipple();
            this.showFlag(a.getBoolean(R.styleable.CountryCodePicker_ccp_showFlag, true));
            this.setDialogKeyboardAutoPopup(a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_keyboardAutoPopup, true));
            int attrLanguage = a.getInt(R.styleable.CountryCodePicker_ccp_defaultLanguage, Language.ENGLISH.ordinal());
            this.customDefaultLanguage = this.getLanguageEnum(attrLanguage);
            this.updateLanguageToApply();
            this.customMasterCountriesParam = a.getString(R.styleable.CountryCodePicker_ccp_customMasterCountries);
            this.excludedCountriesParam = a.getString(R.styleable.CountryCodePicker_ccp_excludedCountries);
            if (!this.isInEditMode()) {
                this.refreshCustomMasterList();
            }
            this.countryPreference = a.getString(R.styleable.CountryCodePicker_ccp_countryPreference);
            if (!this.isInEditMode()) {
                this.refreshPreferredCountries();
            }
            if (a.hasValue(R.styleable.CountryCodePicker_ccp_textGravity)) {
                this.ccpTextgGravity = a.getInt(R.styleable.CountryCodePicker_ccp_textGravity, TEXT_GRAVITY_CENTER);
            }
            this.applyTextGravity(this.ccpTextgGravity);
            this.defaultCountryNameCode = a.getString(R.styleable.CountryCodePicker_ccp_defaultNameCode);
            boolean setUsingNameCode = false;
            if (this.defaultCountryNameCode != null && this.defaultCountryNameCode.length() != 0) {
                if (!this.isInEditMode()) {
                    if (CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), this.defaultCountryNameCode) != null) {
                        setUsingNameCode = true;
                        this.setDefaultCountry(CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), this.defaultCountryNameCode));
                        this.setSelectedCountry(this.defaultCCPCountry);
                    }
                } else if (CCPCountry.getCountryForNameCodeFromEnglishList(this.defaultCountryNameCode) != null) {
                    setUsingNameCode = true;
                    this.setDefaultCountry(CCPCountry.getCountryForNameCodeFromEnglishList(this.defaultCountryNameCode));
                    this.setSelectedCountry(this.defaultCCPCountry);
                }
                if (!setUsingNameCode) {
                    this.setDefaultCountry(CCPCountry.getCountryForNameCodeFromEnglishList("IN"));
                    this.setSelectedCountry(this.defaultCCPCountry);
                    setUsingNameCode = true;
                }
            }
            int defaultCountryCode = a.getInteger(R.styleable.CountryCodePicker_ccp_defaultPhoneCode, -1);
            if (!setUsingNameCode && defaultCountryCode != -1) {
                if (!this.isInEditMode()) {
                    if (defaultCountryCode != -1 && CCPCountry.getCountryForCode(this.getContext(), this.getLanguageToApply(), this.preferredCountries, defaultCountryCode) == null) {
                        defaultCountryCode = LIB_DEFAULT_COUNTRY_CODE;
                    }
                    this.setDefaultCountryUsingPhoneCode(defaultCountryCode);
                    this.setSelectedCountry(this.defaultCCPCountry);
                } else {
                    CCPCountry defaultCountry = CCPCountry.getCountryForCodeFromEnglishList(defaultCountryCode + "");
                    if (defaultCountry == null) {
                        defaultCountry = CCPCountry.getCountryForCodeFromEnglishList(LIB_DEFAULT_COUNTRY_CODE + "");
                    }
                    this.setDefaultCountry(defaultCountry);
                    this.setSelectedCountry(defaultCountry);
                }
            }
            if (this.getDefaultCountry() == null) {
                this.setDefaultCountry(CCPCountry.getCountryForNameCodeFromEnglishList("IN"));
                if (this.getSelectedCountry() == null) {
                    this.setSelectedCountry(this.defaultCCPCountry);
                }
            }
            if (this.isAutoDetectCountryEnabled() && !this.isInEditMode()) {
                this.setAutoDetectedCountry(true);
            }
            if (this.rememberLastSelection && !this.isInEditMode()) {
                this.loadLastSelectedCountryInCCP();
            }
            int arrowColor = a.getColor(R.styleable.CountryCodePicker_ccp_arrowColor, -99);
            this.setArrowColor(arrowColor);
            int contentColor = this.isInEditMode() ? a.getColor(R.styleable.CountryCodePicker_ccp_contentColor, -99) : a.getColor(R.styleable.CountryCodePicker_ccp_contentColor, this.context.getResources().getColor(R.color.defaultContentColor));
            if (contentColor != -99) {
                this.setContentColor(contentColor);
            }
            if ((borderFlagColor = this.isInEditMode() ? a.getColor(R.styleable.CountryCodePicker_ccp_flagBorderColor, 0) : a.getColor(R.styleable.CountryCodePicker_ccp_flagBorderColor, this.context.getResources().getColor(R.color.defaultBorderFlagColor))) != 0) {
                this.setFlagBorderColor(borderFlagColor);
            }
            this.setDialogBackgroundColor(a.getColor(R.styleable.CountryCodePicker_ccpDialog_backgroundColor, 0));
            this.setDialogBackground(a.getResourceId(R.styleable.CountryCodePicker_ccpDialog_background, 0));
            this.setDialogTextColor(a.getColor(R.styleable.CountryCodePicker_ccpDialog_textColor, 0));
            this.setDialogSearchEditTextTintColor(a.getColor(R.styleable.CountryCodePicker_ccpDialog_searchEditTextTint, 0));
            this.setDialogCornerRaius(a.getDimension(R.styleable.CountryCodePicker_ccpDialog_cornerRadius, 0.0f));
            int textSize = a.getDimensionPixelSize(R.styleable.CountryCodePicker_ccp_textSize, 0);
            if (textSize > 0) {
                this.textView_selectedCountry.setTextSize(0, (float)textSize);
                this.setFlagSize(textSize);
                this.setArrowSize(textSize);
            }
            if ((arrowSize = a.getDimensionPixelSize(R.styleable.CountryCodePicker_ccp_arrowSize, 0)) > 0) {
                this.setArrowSize(arrowSize);
            }
            this.searchAllowed = a.getBoolean(R.styleable.CountryCodePicker_ccpDialog_allowSearch, true);
            this.setCcpClickable(a.getBoolean(R.styleable.CountryCodePicker_ccp_clickable, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            a.recycle();
        }
    }

    private void refreshArrowViewVisibility() {
        if (this.showArrow) {
            this.imageViewArrow.setVisibility(0);
        } else {
            this.imageViewArrow.setVisibility(8);
        }
    }

    private void refreshEnableRipple() {
        if (this.rippleEnable) {
            TypedValue outValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(16843534, outValue, true);
            if (outValue.resourceId != 0) {
                this.relativeClickConsumer.setBackgroundResource(outValue.resourceId);
            } else {
                this.relativeClickConsumer.setBackgroundResource(outValue.data);
            }
        }
    }

    private void loadLastSelectedCountryInCCP() {
        SharedPreferences sharedPref = this.context.getSharedPreferences(this.CCP_PREF_FILE, 0);
        String lastSelectedCountryNameCode = sharedPref.getString(this.selectionMemoryTag, null);
        if (lastSelectedCountryNameCode != null) {
            this.setCountryForNameCode(lastSelectedCountryNameCode);
        }
    }

    void storeSelectedCountryNameCode(String selectedCountryNameCode) {
        SharedPreferences sharedPref = this.context.getSharedPreferences(this.CCP_PREF_FILE, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(this.selectionMemoryTag, selectedCountryNameCode);
        editor.apply();
    }

    boolean isCcpDialogShowPhoneCode() {
        return this.ccpDialogShowPhoneCode;
    }

    public void setCcpDialogShowPhoneCode(boolean ccpDialogShowPhoneCode) {
        this.ccpDialogShowPhoneCode = ccpDialogShowPhoneCode;
    }

    public boolean getCcpDialogShowNameCode() {
        return this.ccpDialogShowNameCode;
    }

    public void setCcpDialogShowNameCode(boolean ccpDialogShowNameCode) {
        this.ccpDialogShowNameCode = ccpDialogShowNameCode;
    }

    public boolean getCcpDialogShowTitle() {
        return this.ccpDialogShowTitle;
    }

    public void setCcpDialogShowTitle(boolean ccpDialogShowTitle) {
        this.ccpDialogShowTitle = ccpDialogShowTitle;
    }

    public boolean getCcpDialogShowFlag() {
        return this.ccpDialogShowFlag;
    }

    public void setCcpDialogShowFlag(boolean ccpDialogShowFlag) {
        this.ccpDialogShowFlag = ccpDialogShowFlag;
    }

    public boolean getCcpDialogRippleEnable() {
        return this.ccpDialogRippleEnable;
    }

    public void setCcpDialogRippleEnable(boolean ccpDialogRippleEnable) {
        this.ccpDialogRippleEnable = ccpDialogRippleEnable;
    }

    boolean isShowPhoneCode() {
        return this.showPhoneCode;
    }

    public void setShowPhoneCode(boolean showPhoneCode) {
        this.showPhoneCode = showPhoneCode;
        this.setSelectedCountry(this.selectedCCPCountry);
    }

    protected DialogEventsListener getDialogEventsListener() {
        return this.dialogEventsListener;
    }

    public void setDialogEventsListener(DialogEventsListener dialogEventsListener) {
        this.dialogEventsListener = dialogEventsListener;
    }

    int getFastScrollerBubbleTextAppearance() {
        return this.fastScrollerBubbleTextAppearance;
    }

    public void setFastScrollerBubbleTextAppearance(int fastScrollerBubbleTextAppearance) {
        this.fastScrollerBubbleTextAppearance = fastScrollerBubbleTextAppearance;
    }

    int getFastScrollerHandleColor() {
        return this.fastScrollerHandleColor;
    }

    public void setFastScrollerHandleColor(int fastScrollerHandleColor) {
        this.fastScrollerHandleColor = fastScrollerHandleColor;
    }

    int getFastScrollerBubbleColor() {
        return this.fastScrollerBubbleColor;
    }

    public void setFastScrollerBubbleColor(int fastScrollerBubbleColor) {
        this.fastScrollerBubbleColor = fastScrollerBubbleColor;
    }

    TextGravity getCurrentTextGravity() {
        return this.currentTextGravity;
    }

    public void setCurrentTextGravity(TextGravity textGravity) {
        this.currentTextGravity = textGravity;
        this.applyTextGravity(textGravity.enumIndex);
    }

    private void applyTextGravity(int enumIndex) {
        if (enumIndex == TextGravity.LEFT.enumIndex) {
            this.textView_selectedCountry.setGravity(3);
        } else if (enumIndex == TextGravity.CENTER.enumIndex) {
            this.textView_selectedCountry.setGravity(17);
        } else {
            this.textView_selectedCountry.setGravity(5);
        }
    }

    private void updateLanguageToApply() {
        Language localeBasedLanguage;
        this.languageToApply = this.isInEditMode() ? (this.customDefaultLanguage != null ? this.customDefaultLanguage : Language.ENGLISH) : (this.isAutoDetectLanguageEnabled() ? ((localeBasedLanguage = this.getCCPLanguageFromLocale()) == null ? (this.getCustomDefaultLanguage() != null ? this.getCustomDefaultLanguage() : Language.ENGLISH) : localeBasedLanguage) : (this.getCustomDefaultLanguage() != null ? this.customDefaultLanguage : Language.ENGLISH));
    }

    private Language getCCPLanguageFromLocale() {
        Locale currentLocale = this.context.getResources().getConfiguration().locale;
        for (Language language : Language.values()) {
            if (!language.getCode().equalsIgnoreCase(currentLocale.getLanguage())) continue;
            if (language.getCountry() == null || language.getCountry().equalsIgnoreCase(currentLocale.getCountry())) {
                return language;
            }
            if (Build.VERSION.SDK_INT < 21 || language.getScript() != null && !language.getScript().equalsIgnoreCase(currentLocale.getScript())) continue;
            return language;
        }
        return null;
    }

    private CCPCountry getDefaultCountry() {
        return this.defaultCCPCountry;
    }

    private void setDefaultCountry(CCPCountry defaultCCPCountry) {
        this.defaultCCPCountry = defaultCCPCountry;
    }

    public TextView getTextView_selectedCountry() {
        return this.textView_selectedCountry;
    }

    public void setTextView_selectedCountry(TextView textView_selectedCountry) {
        this.textView_selectedCountry = textView_selectedCountry;
    }

    public ImageView getImageViewFlag() {
        return this.imageViewFlag;
    }

    public void setImageViewFlag(ImageView imageViewFlag) {
        this.imageViewFlag = imageViewFlag;
    }

    private CCPCountry getSelectedCountry() {
        if (this.selectedCCPCountry == null) {
            this.setSelectedCountry(this.getDefaultCountry());
        }
        return this.selectedCCPCountry;
    }

    void setSelectedCountry(CCPCountry selectedCCPCountry) {
        if (this.talkBackTextProvider != null && this.talkBackTextProvider.getTalkBackTextForCountry(selectedCCPCountry) != null) {
            this.textView_selectedCountry.setContentDescription((CharSequence)this.talkBackTextProvider.getTalkBackTextForCountry(selectedCCPCountry));
        }
        this.countryDetectionBasedOnAreaAllowed = false;
        this.lastCheckedAreaCode = "";
        if (selectedCCPCountry == null && (selectedCCPCountry = CCPCountry.getCountryForCode(this.getContext(), this.getLanguageToApply(), this.preferredCountries, this.defaultCountryCode)) == null) {
            return;
        }
        this.selectedCCPCountry = selectedCCPCountry;
        String displayText = "";
        if (this.showFlag && this.ccpUseEmoji) {
            displayText = this.isInEditMode() ? (this.ccpUseDummyEmojiForPreview ? displayText + "\ud83c\udfc1\u200b " : displayText + CCPCountry.getFlagEmoji(selectedCCPCountry) + "\u200b ") : displayText + CCPCountry.getFlagEmoji(selectedCCPCountry) + "  ";
        }
        if (this.showFullName) {
            displayText = displayText + selectedCCPCountry.getName();
        }
        if (this.showNameCode) {
            displayText = this.showFullName ? displayText + " (" + selectedCCPCountry.getNameCode().toUpperCase(Locale.US) + ")" : displayText + " " + selectedCCPCountry.getNameCode().toUpperCase(Locale.US);
        }
        if (this.showPhoneCode) {
            if (displayText.length() > 0) {
                displayText = displayText + "  ";
            }
            displayText = displayText + "+" + selectedCCPCountry.getPhoneCode();
        }
        this.textView_selectedCountry.setText((CharSequence)displayText);
        if (!this.showFlag && displayText.length() == 0) {
            displayText = displayText + "+" + selectedCCPCountry.getPhoneCode();
            this.textView_selectedCountry.setText((CharSequence)displayText);
        }
        this.imageViewFlag.setImageResource(selectedCCPCountry.getFlagID());
        if (this.onCountryChangeListener != null) {
            this.onCountryChangeListener.onCountrySelected();
        }
        this.updateFormattingTextWatcher();
        this.updateHint();
        if (this.editText_registeredCarrierNumber != null && this.phoneNumberValidityChangeListener != null) {
            this.reportedValidity = this.isValidFullNumber();
            this.phoneNumberValidityChangeListener.onValidityChanged(this.reportedValidity);
        }
        this.countryDetectionBasedOnAreaAllowed = true;
        if (this.countryChangedDueToAreaCode) {
            try {
                this.editText_registeredCarrierNumber.setSelection(this.lastCursorPosition);
                this.countryChangedDueToAreaCode = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateCountryGroup();
    }

    private void updateCountryGroup() {
        this.currentCountryGroup = CCPCountryGroup.getCountryGroupForPhoneCode(this.getSelectedCountryCodeAsInt());
    }

    private void updateHint() {
        if (this.editText_registeredCarrierNumber != null && this.hintExampleNumberEnabled) {
            String formattedNumber = "";
            Phonenumber.PhoneNumber exampleNumber = this.getPhoneUtil().getExampleNumberForType(this.getSelectedCountryNameCode(), this.getSelectedHintNumberType());
            if (exampleNumber != null) {
                formattedNumber = exampleNumber.getNationalNumber() + "";
                formattedNumber = Build.VERSION.SDK_INT >= 21 ? PhoneNumberUtils.formatNumber((String)(this.getSelectedCountryCodeWithPlus() + formattedNumber), (String)this.getSelectedCountryNameCode()) : PhoneNumberUtils.formatNumber((String)(this.getSelectedCountryCodeWithPlus() + formattedNumber));
                if (formattedNumber != null) {
                    formattedNumber = formattedNumber.substring(this.getSelectedCountryCodeWithPlus().length()).trim();
                }
            }
            if (formattedNumber == null) {
                formattedNumber = this.originalHint;
            }
            this.editText_registeredCarrierNumber.setHint((CharSequence)formattedNumber);
        }
    }

    private PhoneNumberUtil.PhoneNumberType getSelectedHintNumberType() {
        switch (this.hintExampleNumberType) {
            case MOBILE: {
                return PhoneNumberUtil.PhoneNumberType.MOBILE;
            }
            case FIXED_LINE: {
                return PhoneNumberUtil.PhoneNumberType.FIXED_LINE;
            }
            case FIXED_LINE_OR_MOBILE: {
                return PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            case TOLL_FREE: {
                return PhoneNumberUtil.PhoneNumberType.TOLL_FREE;
            }
            case PREMIUM_RATE: {
                return PhoneNumberUtil.PhoneNumberType.PREMIUM_RATE;
            }
            case SHARED_COST: {
                return PhoneNumberUtil.PhoneNumberType.SHARED_COST;
            }
            case VOIP: {
                return PhoneNumberUtil.PhoneNumberType.VOIP;
            }
            case PERSONAL_NUMBER: {
                return PhoneNumberUtil.PhoneNumberType.PERSONAL_NUMBER;
            }
            case PAGER: {
                return PhoneNumberUtil.PhoneNumberType.PAGER;
            }
            case UAN: {
                return PhoneNumberUtil.PhoneNumberType.UAN;
            }
            case VOICEMAIL: {
                return PhoneNumberUtil.PhoneNumberType.VOICEMAIL;
            }
            case UNKNOWN: {
                return PhoneNumberUtil.PhoneNumberType.UNKNOWN;
            }
        }
        return PhoneNumberUtil.PhoneNumberType.MOBILE;
    }

    public Language getLanguageToApply() {
        if (this.languageToApply == null) {
            this.updateLanguageToApply();
        }
        return this.languageToApply;
    }

    void setLanguageToApply(Language languageToApply) {
        this.languageToApply = languageToApply;
    }

    private void updateFormattingTextWatcher() {
        if (this.editText_registeredCarrierNumber != null && this.selectedCCPCountry != null) {
            String enteredValue = this.getEditText_registeredCarrierNumber().getText().toString();
            String digitsValue = PhoneNumberUtil.normalizeDigitsOnly((CharSequence)enteredValue);
            if (this.formattingTextWatcher != null) {
                this.editText_registeredCarrierNumber.removeTextChangedListener((TextWatcher)this.formattingTextWatcher);
            }
            if (this.areaCodeCountryDetectorTextWatcher != null) {
                this.editText_registeredCarrierNumber.removeTextChangedListener(this.areaCodeCountryDetectorTextWatcher);
            }
            if (this.numberAutoFormattingEnabled) {
                this.formattingTextWatcher = new InternationalPhoneTextWatcher(this.context, this.getSelectedCountryNameCode(), this.getSelectedCountryCodeAsInt(), this.internationalFormattingOnly);
                this.editText_registeredCarrierNumber.addTextChangedListener((TextWatcher)this.formattingTextWatcher);
            }
            if (this.detectCountryWithAreaCode) {
                this.areaCodeCountryDetectorTextWatcher = this.getCountryDetectorTextWatcher();
                this.editText_registeredCarrierNumber.addTextChangedListener(this.areaCodeCountryDetectorTextWatcher);
            }
            this.editText_registeredCarrierNumber.setText((CharSequence)"");
            this.editText_registeredCarrierNumber.setText((CharSequence)digitsValue);
            this.editText_registeredCarrierNumber.setSelection(this.editText_registeredCarrierNumber.getText().length());
        } else if (this.editText_registeredCarrierNumber == null) {
            Log.v((String)TAG, (String)("updateFormattingTextWatcher: EditText not registered " + this.selectionMemoryTag));
        } else {
            Log.v((String)TAG, (String)("updateFormattingTextWatcher: selected country is null " + this.selectionMemoryTag));
        }
    }

    private TextWatcher getCountryDetectorTextWatcher() {
        if (this.editText_registeredCarrierNumber != null && this.areaCodeCountryDetectorTextWatcher == null) {
            this.areaCodeCountryDetectorTextWatcher = new TextWatcher(){
                String lastCheckedNumber = null;

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    CCPCountry selectedCountry = CountryCodePicker.this.getSelectedCountry();
                    if (selectedCountry != null && (this.lastCheckedNumber == null || !this.lastCheckedNumber.equals(s.toString())) && CountryCodePicker.this.countryDetectionBasedOnAreaAllowed) {
                        String currentAreaCode;
                        String digitsValue;
                        String enteredValue;
                        if (CountryCodePicker.this.currentCountryGroup != null && (enteredValue = CountryCodePicker.this.getEditText_registeredCarrierNumber().getText().toString()).length() >= ((CountryCodePicker)CountryCodePicker.this).currentCountryGroup.areaCodeLength && (digitsValue = PhoneNumberUtil.normalizeDigitsOnly((CharSequence)enteredValue)).length() >= ((CountryCodePicker)CountryCodePicker.this).currentCountryGroup.areaCodeLength && !(currentAreaCode = digitsValue.substring(0, ((CountryCodePicker)CountryCodePicker.this).currentCountryGroup.areaCodeLength)).equals(CountryCodePicker.this.lastCheckedAreaCode)) {
                            CCPCountry detectedCountry = CountryCodePicker.this.currentCountryGroup.getCountryForAreaCode(CountryCodePicker.this.context, CountryCodePicker.this.getLanguageToApply(), currentAreaCode);
                            if (!detectedCountry.equals(selectedCountry)) {
                                CountryCodePicker.this.countryChangedDueToAreaCode = true;
                                CountryCodePicker.this.lastCursorPosition = Selection.getSelectionEnd((CharSequence)s);
                                CountryCodePicker.this.setSelectedCountry(detectedCountry);
                            }
                            CountryCodePicker.this.lastCheckedAreaCode = currentAreaCode;
                        }
                        this.lastCheckedNumber = s.toString();
                    }
                }

                public void afterTextChanged(Editable s) {
                }
            };
        }
        return this.areaCodeCountryDetectorTextWatcher;
    }

    Language getCustomDefaultLanguage() {
        return this.customDefaultLanguage;
    }

    private void setCustomDefaultLanguage(Language customDefaultLanguage) {
        CCPCountry country;
        this.customDefaultLanguage = customDefaultLanguage;
        this.updateLanguageToApply();
        if (this.selectedCCPCountry != null && (country = CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.context, this.getLanguageToApply(), this.selectedCCPCountry.getNameCode())) != null) {
            this.setSelectedCountry(country);
        }
    }

    private View getHolderView() {
        return this.holderView;
    }

    private void setHolderView(View holderView) {
        this.holderView = holderView;
    }

    public RelativeLayout getHolder() {
        return this.holder;
    }

    private void setHolder(RelativeLayout holder) {
        this.holder = holder;
    }

    boolean isAutoDetectLanguageEnabled() {
        return this.autoDetectLanguageEnabled;
    }

    boolean isAutoDetectCountryEnabled() {
        return this.autoDetectCountryEnabled;
    }

    boolean isDialogKeyboardAutoPopup() {
        return this.dialogKeyboardAutoPopup;
    }

    public void setDialogKeyboardAutoPopup(boolean dialogKeyboardAutoPopup) {
        this.dialogKeyboardAutoPopup = dialogKeyboardAutoPopup;
    }

    boolean isShowFastScroller() {
        return this.showFastScroller;
    }

    public void setShowFastScroller(boolean showFastScroller) {
        this.showFastScroller = showFastScroller;
    }

    protected boolean isShowCloseIcon() {
        return this.showCloseIcon;
    }

    public void showCloseIcon(boolean showCloseIcon) {
        this.showCloseIcon = showCloseIcon;
    }

    EditText getEditText_registeredCarrierNumber() {
        return this.editText_registeredCarrierNumber;
    }

    void setEditText_registeredCarrierNumber(EditText editText_registeredCarrierNumber) {
        this.editText_registeredCarrierNumber = editText_registeredCarrierNumber;
        if (this.editText_registeredCarrierNumber.getHint() != null) {
            this.originalHint = this.editText_registeredCarrierNumber.getHint().toString();
        }
        this.updateValidityTextWatcher();
        this.updateFormattingTextWatcher();
        this.updateHint();
    }

    private void updateValidityTextWatcher() {
        try {
            this.editText_registeredCarrierNumber.removeTextChangedListener(this.validityTextWatcher);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reportedValidity = this.isValidFullNumber();
        if (this.phoneNumberValidityChangeListener != null) {
            this.phoneNumberValidityChangeListener.onValidityChanged(this.reportedValidity);
        }
        this.validityTextWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                boolean currentValidity;
                if (CountryCodePicker.this.phoneNumberValidityChangeListener != null && (currentValidity = CountryCodePicker.this.isValidFullNumber()) != CountryCodePicker.this.reportedValidity) {
                    CountryCodePicker.this.reportedValidity = currentValidity;
                    CountryCodePicker.this.phoneNumberValidityChangeListener.onValidityChanged(CountryCodePicker.this.reportedValidity);
                }
            }
        };
        this.editText_registeredCarrierNumber.addTextChangedListener(this.validityTextWatcher);
    }

    private LayoutInflater getmInflater() {
        return this.mInflater;
    }

    private View.OnClickListener getCountryCodeHolderClickListener() {
        return this.countryCodeHolderClickListener;
    }

    int getDialogBackgroundColor() {
        return this.dialogBackgroundColor;
    }

    public void setDialogBackgroundColor(int dialogBackgroundColor) {
        this.dialogBackgroundColor = dialogBackgroundColor;
    }

    int getDialogBackgroundResId() {
        return this.dialogBackgroundResId;
    }

    public void setDialogBackground(@IdRes int dialogBackgroundResId) {
        this.dialogBackgroundResId = dialogBackgroundResId;
    }

    int getDialogSearchEditTextTintColor() {
        return this.dialogSearchEditTextTintColor;
    }

    public void setDialogSearchEditTextTintColor(int dialogSearchEditTextTintColor) {
        this.dialogSearchEditTextTintColor = dialogSearchEditTextTintColor;
    }

    public float getDialogCornerRadius() {
        return this.dialogCornerRadius;
    }

    public void setDialogCornerRaius(float dialogCornerRadius) {
        this.dialogCornerRadius = dialogCornerRadius;
    }

    int getDialogTextColor() {
        return this.dialogTextColor;
    }

    public void setDialogTextColor(int dialogTextColor) {
        this.dialogTextColor = dialogTextColor;
    }

    int getDialogTypeFaceStyle() {
        return this.dialogTypeFaceStyle;
    }

    Typeface getDialogTypeFace() {
        return this.dialogTypeFace;
    }

    public void setDialogTypeFace(Typeface typeFace) {
        try {
            this.dialogTypeFace = typeFace;
            this.dialogTypeFaceStyle = -99;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void refreshPreferredCountries() {
        if (this.countryPreference == null || this.countryPreference.length() == 0) {
            this.preferredCountries = null;
        } else {
            ArrayList<CCPCountry> localCCPCountryList = new ArrayList<CCPCountry>();
            for (String nameCode : this.countryPreference.split(",")) {
                CCPCountry ccpCountry = CCPCountry.getCountryForNameCodeFromCustomMasterList(this.getContext(), this.customMasterCountriesList, this.getLanguageToApply(), nameCode);
                if (ccpCountry == null || this.isAlreadyInList(ccpCountry, localCCPCountryList)) continue;
                localCCPCountryList.add(ccpCountry);
            }
            this.preferredCountries = localCCPCountryList.size() == 0 ? null : localCCPCountryList;
        }
        if (this.preferredCountries != null) {
            for (CCPCountry CCPCountry2 : this.preferredCountries) {
                CCPCountry2.log();
            }
        }
    }

    void refreshCustomMasterList() {
        if (this.customMasterCountriesParam == null || this.customMasterCountriesParam.length() == 0) {
            if (this.excludedCountriesParam != null && this.excludedCountriesParam.length() != 0) {
                this.excludedCountriesParam = this.excludedCountriesParam.toLowerCase();
                List<CCPCountry> libraryMasterList = CCPCountry.getLibraryMasterCountryList(this.context, this.getLanguageToApply());
                ArrayList localCCPCountryList = new ArrayList();
                for (CCPCountry ccpCountry : libraryMasterList) {
                    if (this.excludedCountriesParam.contains(ccpCountry.getNameCode().toLowerCase())) continue;
                    localCCPCountryList.add(ccpCountry);
                }
                this.customMasterCountriesList = localCCPCountryList.size() > 0 ? localCCPCountryList : null;
            } else {
                this.customMasterCountriesList = null;
            }
        } else {
            ArrayList<CCPCountry> localCCPCountryList = new ArrayList<CCPCountry>();
            for (String nameCode : this.customMasterCountriesParam.split(",")) {
                CCPCountry ccpCountry = CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), nameCode);
                if (ccpCountry == null || this.isAlreadyInList(ccpCountry, localCCPCountryList)) continue;
                localCCPCountryList.add(ccpCountry);
            }
            this.customMasterCountriesList = localCCPCountryList.size() == 0 ? null : localCCPCountryList;
        }
        if (this.customMasterCountriesList != null) {
            for (CCPCountry ccpCountry : this.customMasterCountriesList) {
                ccpCountry.log();
            }
        }
    }

    List<CCPCountry> getCustomMasterCountriesList() {
        return this.customMasterCountriesList;
    }

    void setCustomMasterCountriesList(List<CCPCountry> customMasterCountriesList) {
        this.customMasterCountriesList = customMasterCountriesList;
    }

    String getCustomMasterCountriesParam() {
        return this.customMasterCountriesParam;
    }

    public void setCustomMasterCountries(String customMasterCountriesParam) {
        this.customMasterCountriesParam = customMasterCountriesParam;
    }

    public void setExcludedCountries(String excludedCountries) {
        this.excludedCountriesParam = excludedCountries;
        this.refreshCustomMasterList();
    }

    boolean isCcpClickable() {
        return this.ccpClickable;
    }

    public void setCcpClickable(boolean ccpClickable) {
        this.ccpClickable = ccpClickable;
        if (!ccpClickable) {
            this.relativeClickConsumer.setOnClickListener(null);
            this.relativeClickConsumer.setClickable(false);
            this.relativeClickConsumer.setEnabled(false);
        } else {
            this.relativeClickConsumer.setOnClickListener(this.countryCodeHolderClickListener);
            this.relativeClickConsumer.setClickable(true);
            this.relativeClickConsumer.setEnabled(true);
        }
    }

    private boolean isAlreadyInList(CCPCountry CCPCountry2, List<CCPCountry> CCPCountryList) {
        if (CCPCountry2 != null && CCPCountryList != null) {
            for (CCPCountry iterationCCPCountry : CCPCountryList) {
                if (!iterationCCPCountry.getNameCode().equalsIgnoreCase(CCPCountry2.getNameCode())) continue;
                return true;
            }
        }
        return false;
    }

    private String detectCarrierNumber(String fullNumber, CCPCountry CCPCountry2) {
        int indexOfCode;
        String carrierNumber = CCPCountry2 == null || fullNumber == null || fullNumber.isEmpty() ? fullNumber : ((indexOfCode = fullNumber.indexOf(CCPCountry2.getPhoneCode())) == -1 ? fullNumber : fullNumber.substring(indexOfCode + CCPCountry2.getPhoneCode().length()));
        return carrierNumber;
    }

    private Language getLanguageEnum(int index) {
        if (index < Language.values().length) {
            return Language.values()[index];
        }
        return Language.ENGLISH;
    }

    String getDialogTitle() {
        String defaultTitle = CCPCountry.getDialogTitle(this.context, this.getLanguageToApply());
        if (this.customDialogTextProvider != null) {
            return this.customDialogTextProvider.getCCPDialogTitle(this.getLanguageToApply(), defaultTitle);
        }
        return defaultTitle;
    }

    String getSearchHintText() {
        String defaultHint = CCPCountry.getSearchHintMessage(this.context, this.getLanguageToApply());
        if (this.customDialogTextProvider != null) {
            return this.customDialogTextProvider.getCCPDialogSearchHintText(this.getLanguageToApply(), defaultHint);
        }
        return defaultHint;
    }

    String getNoResultACK() {
        String defaultNoResultACK = CCPCountry.getNoResultFoundAckMessage(this.context, this.getLanguageToApply());
        if (this.customDialogTextProvider != null) {
            return this.customDialogTextProvider.getCCPDialogNoResultACK(this.getLanguageToApply(), defaultNoResultACK);
        }
        return defaultNoResultACK;
    }

    @Deprecated
    public void setDefaultCountryUsingPhoneCode(int defaultCountryCode) {
        CCPCountry defaultCCPCountry = CCPCountry.getCountryForCode(this.getContext(), this.getLanguageToApply(), this.preferredCountries, defaultCountryCode);
        if (defaultCCPCountry != null) {
            this.defaultCountryCode = defaultCountryCode;
            this.setDefaultCountry(defaultCCPCountry);
        }
    }

    public void setDefaultCountryUsingNameCode(String defaultCountryNameCode) {
        CCPCountry defaultCCPCountry = CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), defaultCountryNameCode);
        if (defaultCCPCountry != null) {
            this.defaultCountryNameCode = defaultCCPCountry.getNameCode();
            this.setDefaultCountry(defaultCCPCountry);
        }
    }

    public String getDefaultCountryCode() {
        return this.defaultCCPCountry.phoneCode;
    }

    public int getDefaultCountryCodeAsInt() {
        int code = 0;
        try {
            code = Integer.parseInt(this.getDefaultCountryCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public String getDefaultCountryCodeWithPlus() {
        return "+" + this.getDefaultCountryCode();
    }

    public String getDefaultCountryName() {
        CCPCountry dc = this.getDefaultCountry();
        if (dc == null) {
            return "";
        }
        return dc.name;
    }

    public String getDefaultCountryNameCode() {
        CCPCountry dc = this.getDefaultCountry();
        if (dc == null) {
            return "";
        }
        return dc.nameCode.toUpperCase(Locale.US);
    }

    public void resetToDefaultCountry() {
        this.defaultCCPCountry = CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), this.getDefaultCountryNameCode());
        this.setSelectedCountry(this.defaultCCPCountry);
    }

    public String getSelectedCountryCode() {
        return this.getSelectedCountry().phoneCode;
    }

    public String getSelectedCountryCodeWithPlus() {
        return "+" + this.getSelectedCountryCode();
    }

    public int getSelectedCountryCodeAsInt() {
        int code = 0;
        try {
            code = Integer.parseInt(this.getSelectedCountryCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public String getSelectedCountryName() {
        return this.getSelectedCountry().name;
    }

    public String getSelectedCountryEnglishName() {
        return this.getSelectedCountry().getEnglishName();
    }

    public String getSelectedCountryNameCode() {
        return this.getSelectedCountry().nameCode.toUpperCase(Locale.US);
    }

    @DrawableRes
    public int getSelectedCountryFlagResourceId() {
        return this.getSelectedCountry().flagResID;
    }

    public void setCountryForPhoneCode(int countryCode) {
        CCPCountry ccpCountry = CCPCountry.getCountryForCode(this.getContext(), this.getLanguageToApply(), this.preferredCountries, countryCode);
        if (ccpCountry == null) {
            if (this.defaultCCPCountry == null) {
                this.defaultCCPCountry = CCPCountry.getCountryForCode(this.getContext(), this.getLanguageToApply(), this.preferredCountries, this.defaultCountryCode);
            }
            this.setSelectedCountry(this.defaultCCPCountry);
        } else {
            this.setSelectedCountry(ccpCountry);
        }
    }

    public void setCountryForNameCode(String countryNameCode) {
        CCPCountry country = CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), countryNameCode);
        if (country == null) {
            if (this.defaultCCPCountry == null) {
                this.defaultCCPCountry = CCPCountry.getCountryForCode(this.getContext(), this.getLanguageToApply(), this.preferredCountries, this.defaultCountryCode);
            }
            this.setSelectedCountry(this.defaultCCPCountry);
        } else {
            this.setSelectedCountry(country);
        }
    }

    public void registerCarrierNumberEditText(EditText editTextCarrierNumber) {
        this.setEditText_registeredCarrierNumber(editTextCarrierNumber);
    }

    public void deregisterCarrierNumberEditText() {
        if (this.editText_registeredCarrierNumber != null) {
            try {
                this.editText_registeredCarrierNumber.removeTextChangedListener(this.validityTextWatcher);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.editText_registeredCarrierNumber.removeTextChangedListener((TextWatcher)this.formattingTextWatcher);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.editText_registeredCarrierNumber.setHint((CharSequence)"");
            this.editText_registeredCarrierNumber = null;
        }
    }

    private Phonenumber.PhoneNumber getEnteredPhoneNumber() throws NumberParseException {
        String carrierNumber = "";
        if (this.editText_registeredCarrierNumber != null) {
            carrierNumber = PhoneNumberUtil.normalizeDigitsOnly((CharSequence)this.editText_registeredCarrierNumber.getText().toString());
        }
        return this.getPhoneUtil().parse((CharSequence)carrierNumber, this.getSelectedCountryNameCode());
    }

    public String getFullNumber() {
        try {
            Phonenumber.PhoneNumber phoneNumber = this.getEnteredPhoneNumber();
            return this.getPhoneUtil().format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164).substring(1);
        }
        catch (NumberParseException e) {
            Log.e((String)TAG, (String)"getFullNumber: Could not parse number");
            return this.getSelectedCountryCode() + PhoneNumberUtil.normalizeDigitsOnly((CharSequence)this.editText_registeredCarrierNumber.getText().toString());
        }
    }

    public void setFullNumber(String fullNumber) {
        CCPCountry country = CCPCountry.getCountryForNumber(this.getContext(), this.getLanguageToApply(), this.preferredCountries, fullNumber);
        if (country == null) {
            country = this.getDefaultCountry();
        }
        this.setSelectedCountry(country);
        String carrierNumber = this.detectCarrierNumber(fullNumber, country);
        if (this.getEditText_registeredCarrierNumber() != null) {
            this.getEditText_registeredCarrierNumber().setText((CharSequence)carrierNumber);
            this.updateFormattingTextWatcher();
        } else {
            Log.w((String)TAG, (String)"EditText for carrier number is not registered. Register it using registerCarrierNumberEditText() before getFullNumber() or setFullNumber().");
        }
    }

    public String getFormattedFullNumber() {
        try {
            Phonenumber.PhoneNumber phoneNumber = this.getEnteredPhoneNumber();
            return "+" + this.getPhoneUtil().format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL).substring(1);
        }
        catch (NumberParseException e) {
            Log.e((String)TAG, (String)"getFullNumber: Could not parse number");
            return this.getFullNumberWithPlus();
        }
    }

    public String getFullNumberWithPlus() {
        return "+" + this.getFullNumber();
    }

    public int getContentColor() {
        return this.contentColor;
    }

    public void setContentColor(int contentColor) {
        this.contentColor = contentColor;
        this.textView_selectedCountry.setTextColor(this.contentColor);
        if (this.arrowColor == -99) {
            this.imageViewArrow.setColorFilter(this.contentColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public void setArrowColor(int arrowColor) {
        this.arrowColor = arrowColor;
        if (this.arrowColor == -99) {
            if (this.contentColor != -99) {
                this.imageViewArrow.setColorFilter(this.contentColor, PorterDuff.Mode.SRC_IN);
            }
        } else {
            this.imageViewArrow.setColorFilter(this.arrowColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public void setFlagBorderColor(int borderFlagColor) {
        this.borderFlagColor = borderFlagColor;
        this.linearFlagBorder.setBackgroundColor(this.borderFlagColor);
    }

    public void setTextSize(int textSize) {
        if (textSize > 0) {
            this.textView_selectedCountry.setTextSize(0, (float)textSize);
            this.setArrowSize(textSize);
            this.setFlagSize(textSize);
        }
    }

    public void setArrowSize(int arrowSize) {
        if (arrowSize > 0) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.imageViewArrow.getLayoutParams();
            params.width = arrowSize;
            params.height = arrowSize;
            this.imageViewArrow.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public void showNameCode(boolean showNameCode) {
        this.showNameCode = showNameCode;
        this.setSelectedCountry(this.selectedCCPCountry);
    }

    public void showArrow(boolean showArrow) {
        this.showArrow = showArrow;
        this.refreshArrowViewVisibility();
    }

    public void setCountryPreference(String countryPreference) {
        this.countryPreference = countryPreference;
    }

    public void changeDefaultLanguage(Language language) {
        this.setCustomDefaultLanguage(language);
    }

    public void setTypeFace(Typeface typeFace) {
        try {
            this.textView_selectedCountry.setTypeface(typeFace);
            this.setDialogTypeFace(typeFace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDialogTypeFace(Typeface typeFace, int style) {
        try {
            this.dialogTypeFace = typeFace;
            if (this.dialogTypeFace == null) {
                style = -99;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTypeFace(Typeface typeFace, int style) {
        try {
            this.textView_selectedCountry.setTypeface(typeFace, style);
            this.setDialogTypeFace(typeFace, style);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnCountryChangeListener(OnCountryChangeListener onCountryChangeListener) {
        this.onCountryChangeListener = onCountryChangeListener;
    }

    public void setFlagSize(int flagSize) {
        this.imageViewFlag.getLayoutParams().height = flagSize;
        this.imageViewFlag.requestLayout();
    }

    public void showFlag(boolean showFlag) {
        this.showFlag = showFlag;
        this.refreshFlagVisibility();
        if (!this.isInEditMode()) {
            this.setSelectedCountry(this.selectedCCPCountry);
        }
    }

    private void refreshFlagVisibility() {
        if (this.showFlag) {
            if (this.ccpUseEmoji) {
                this.linearFlagHolder.setVisibility(8);
            } else {
                this.linearFlagHolder.setVisibility(0);
            }
        } else {
            this.linearFlagHolder.setVisibility(8);
        }
    }

    public void useFlagEmoji(boolean useFlagEmoji) {
        this.ccpUseEmoji = useFlagEmoji;
        this.refreshFlagVisibility();
        this.setSelectedCountry(this.selectedCCPCountry);
    }

    public void showFullName(boolean showFullName) {
        this.showFullName = showFullName;
        this.setSelectedCountry(this.selectedCCPCountry);
    }

    public boolean isSearchAllowed() {
        return this.searchAllowed;
    }

    public void setSearchAllowed(boolean searchAllowed) {
        this.searchAllowed = searchAllowed;
    }

    public void setPhoneNumberValidityChangeListener(PhoneNumberValidityChangeListener phoneNumberValidityChangeListener) {
        this.phoneNumberValidityChangeListener = phoneNumberValidityChangeListener;
        if (this.editText_registeredCarrierNumber != null && phoneNumberValidityChangeListener != null) {
            this.reportedValidity = this.isValidFullNumber();
            phoneNumberValidityChangeListener.onValidityChanged(this.reportedValidity);
        }
    }

    public void setAutoDetectionFailureListener(FailureListener failureListener) {
        this.failureListener = failureListener;
    }

    public void setCustomDialogTextProvider(CustomDialogTextProvider customDialogTextProvider) {
        this.customDialogTextProvider = customDialogTextProvider;
    }

    public void launchCountrySelectionDialog() {
        this.launchCountrySelectionDialog(null);
    }

    public void launchCountrySelectionDialog(String countryNameCode) {
        CountryCodeDialog.openCountryCodeDialog(this.codePicker, countryNameCode);
    }

    public boolean isValidFullNumber() {
        try {
            if (this.getEditText_registeredCarrierNumber() != null && this.getEditText_registeredCarrierNumber().getText().length() != 0) {
                Phonenumber.PhoneNumber phoneNumber = this.getPhoneUtil().parse((CharSequence)("+" + this.selectedCCPCountry.getPhoneCode() + this.getEditText_registeredCarrierNumber().getText().toString()), this.selectedCCPCountry.getNameCode());
                return this.getPhoneUtil().isValidNumber(phoneNumber);
            }
            if (this.getEditText_registeredCarrierNumber() == null) {
                Toast.makeText((Context)this.context, (CharSequence)"No editText for Carrier number found.", (int)0).show();
                return false;
            }
            return false;
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    private PhoneNumberUtil getPhoneUtil() {
        if (this.phoneUtil == null) {
            this.phoneUtil = PhoneNumberUtil.createInstance((Context)this.context);
        }
        return this.phoneUtil;
    }

    public void setAutoDetectedCountry(boolean loadDefaultWhenFails) {
        block9: {
            try {
                boolean successfullyDetected = false;
                for (int i = 0; i < this.selectedAutoDetectionPref.representation.length(); ++i) {
                    switch (this.selectedAutoDetectionPref.representation.charAt(i)) {
                        case '1': {
                            successfullyDetected = this.detectSIMCountry(false);
                            break;
                        }
                        case '2': {
                            successfullyDetected = this.detectNetworkCountry(false);
                            break;
                        }
                        case '3': {
                            successfullyDetected = this.detectLocaleCountry(false);
                        }
                    }
                    if (successfullyDetected) break;
                    if (this.failureListener == null) continue;
                    this.failureListener.onCountryAutoDetectionFailed();
                }
                if (!successfullyDetected && loadDefaultWhenFails) {
                    this.resetToDefaultCountry();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.w((String)TAG, (String)("setAutoDetectCountry: Exception" + e.getMessage()));
                if (!loadDefaultWhenFails) break block9;
                this.resetToDefaultCountry();
            }
        }
    }

    public boolean detectSIMCountry(boolean loadDefaultWhenFails) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
            String simCountryISO = telephonyManager.getSimCountryIso();
            if (simCountryISO == null || simCountryISO.isEmpty() || !this.isNameCodeInCustomMasterList(simCountryISO)) {
                if (loadDefaultWhenFails) {
                    this.resetToDefaultCountry();
                }
                return false;
            }
            this.setSelectedCountry(CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), simCountryISO));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (loadDefaultWhenFails) {
                this.resetToDefaultCountry();
            }
            return false;
        }
    }

    private boolean isNameCodeInCustomMasterList(String nameCode) {
        List<CCPCountry> allowedList = CCPCountry.getCustomMasterCountryList(this.context, this);
        for (CCPCountry country : allowedList) {
            if (!country.nameCode.equalsIgnoreCase(nameCode)) continue;
            return true;
        }
        return false;
    }

    public boolean detectNetworkCountry(boolean loadDefaultWhenFails) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
            String networkCountryISO = telephonyManager.getNetworkCountryIso();
            if (networkCountryISO == null || networkCountryISO.isEmpty() || !this.isNameCodeInCustomMasterList(networkCountryISO)) {
                if (loadDefaultWhenFails) {
                    this.resetToDefaultCountry();
                }
                return false;
            }
            this.setSelectedCountry(CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), networkCountryISO));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (loadDefaultWhenFails) {
                this.resetToDefaultCountry();
            }
            return false;
        }
    }

    public boolean detectLocaleCountry(boolean loadDefaultWhenFails) {
        try {
            String localeCountryISO = this.context.getResources().getConfiguration().locale.getCountry();
            if (localeCountryISO == null || localeCountryISO.isEmpty() || !this.isNameCodeInCustomMasterList(localeCountryISO)) {
                if (loadDefaultWhenFails) {
                    this.resetToDefaultCountry();
                }
                return false;
            }
            this.setSelectedCountry(CCPCountry.getCountryForNameCodeFromLibraryMasterList(this.getContext(), this.getLanguageToApply(), localeCountryISO));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (loadDefaultWhenFails) {
                this.resetToDefaultCountry();
            }
            return false;
        }
    }

    public void setCountryAutoDetectionPref(AutoDetectionPref selectedAutoDetectionPref) {
        this.selectedAutoDetectionPref = selectedAutoDetectionPref;
    }

    protected void onUserTappedCountry(CCPCountry CCPCountry2) {
        if (this.codePicker.rememberLastSelection) {
            this.codePicker.storeSelectedCountryNameCode(CCPCountry2.getNameCode());
        }
        this.setSelectedCountry(CCPCountry2);
    }

    public void setDetectCountryWithAreaCode(boolean detectCountryWithAreaCode) {
        this.detectCountryWithAreaCode = detectCountryWithAreaCode;
        this.updateFormattingTextWatcher();
    }

    public void setHintExampleNumberEnabled(boolean hintExampleNumberEnabled) {
        this.hintExampleNumberEnabled = hintExampleNumberEnabled;
        this.updateHint();
    }

    public void setHintExampleNumberType(PhoneNumberType hintExampleNumberType) {
        this.hintExampleNumberType = hintExampleNumberType;
        this.updateHint();
    }

    public boolean isDialogInitialScrollToSelectionEnabled() {
        return this.ccpDialogInitialScrollToSelection;
    }

    public void setTalkBackTextProvider(CCPTalkBackTextProvider talkBackTextProvider) {
        this.talkBackTextProvider = talkBackTextProvider;
        this.setSelectedCountry(this.selectedCCPCountry);
    }

    public void enableDialogInitialScrollToSelection(boolean initialScrollToSelection) {
        this.ccpDialogInitialScrollToSelection = this.ccpDialogInitialScrollToSelection;
    }

    public void overrideClickListener(View.OnClickListener clickListener) {
        this.customClickListener = clickListener;
    }

    protected void onDetachedFromWindow() {
        CountryCodeDialog.clear();
        super.onDetachedFromWindow();
    }

    public static interface CustomDialogTextProvider {
        public String getCCPDialogTitle(Language var1, String var2);

        public String getCCPDialogSearchHintText(Language var1, String var2);

        public String getCCPDialogNoResultACK(Language var1, String var2);
    }

    public static interface DialogEventsListener {
        public void onCcpDialogOpen(Dialog var1);

        public void onCcpDialogDismiss(DialogInterface var1);

        public void onCcpDialogCancel(DialogInterface var1);
    }

    public static interface PhoneNumberValidityChangeListener {
        public void onValidityChanged(boolean var1);
    }

    public static interface FailureListener {
        public void onCountryAutoDetectionFailed();
    }

    public static interface OnCountryChangeListener {
        public void onCountrySelected();
    }

    public static enum TextGravity {
        LEFT(-1),
        CENTER(0),
        RIGHT(1);

        int enumIndex;

        private TextGravity(int i) {
            this.enumIndex = i;
        }
    }

    public static enum AutoDetectionPref {
        SIM_ONLY("1"),
        NETWORK_ONLY("2"),
        LOCALE_ONLY("3"),
        SIM_NETWORK("12"),
        NETWORK_SIM("21"),
        SIM_LOCALE("13"),
        LOCALE_SIM("31"),
        NETWORK_LOCALE("23"),
        LOCALE_NETWORK("32"),
        SIM_NETWORK_LOCALE("123"),
        SIM_LOCALE_NETWORK("132"),
        NETWORK_SIM_LOCALE("213"),
        NETWORK_LOCALE_SIM("231"),
        LOCALE_SIM_NETWORK("312"),
        LOCALE_NETWORK_SIM("321");

        String representation;

        private AutoDetectionPref(String representation) {
            this.representation = representation;
        }

        public static AutoDetectionPref getPrefForValue(String value) {
            for (AutoDetectionPref autoDetectionPref : AutoDetectionPref.values()) {
                if (!autoDetectionPref.representation.equals(value)) continue;
                return autoDetectionPref;
            }
            return SIM_NETWORK_LOCALE;
        }
    }

    public static enum PhoneNumberType {
        MOBILE,
        FIXED_LINE,
        FIXED_LINE_OR_MOBILE,
        TOLL_FREE,
        PREMIUM_RATE,
        SHARED_COST,
        VOIP,
        PERSONAL_NUMBER,
        PAGER,
        UAN,
        VOICEMAIL,
        UNKNOWN;

    }

    public static enum Language {
        AFRIKAANS("af"),
        ARABIC("ar"),
        BASQUE("eu"),
        BELARUSIAN("by"),
        BENGALI("bn"),
        CHINESE_SIMPLIFIED("zh", "CN", "Hans"),
        CHINESE_TRADITIONAL("zh", "TW", "Hant"),
        CZECH("cs"),
        DANISH("da"),
        DUTCH("nl"),
        ENGLISH("en"),
        FARSI("fa"),
        FRENCH("fr"),
        GERMAN("de"),
        GREEK("el"),
        GUJARATI("gu"),
        HAUSA("ha"),
        HEBREW("iw"),
        HINDI("hi"),
        HUNGARIAN("hu"),
        INDONESIA("in"),
        ITALIAN("it"),
        JAPANESE("ja"),
        KAZAKH("kk"),
        KOREAN("ko"),
        MARATHI("mr"),
        POLISH("pl"),
        PORTUGUESE("pt"),
        PUNJABI("pa"),
        RUSSIAN("ru"),
        SERBIAN("sr"),
        SLOVAK("sk"),
        SLOVENIAN("si"),
        SPANISH("es"),
        SWEDISH("sv"),
        TAGALOG("tl"),
        TAMIL("ta"),
        THAI("th"),
        TURKISH("tr"),
        UKRAINIAN("uk"),
        URDU("ur"),
        UZBEK("uz"),
        VIETNAMESE("vi");

        private String code;
        private String country;
        private String script;

        private Language(String code, String country, String script) {
            this.code = code;
            this.country = country;
            this.script = script;
        }

        private Language(String code) {
            this.code = code;
        }

        public static Language forCountryNameCode(String code) {
            Language lang = ENGLISH;
            for (Language language : Language.values()) {
                if (!language.code.equals(code)) continue;
                lang = language;
            }
            return lang;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }
    }
}

