/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SpockParameterClassVisitor
extends TestsReader.Visitor<Map<String, List<String>>> {
    private final Set<String> failedTestNames;
    private final TestsReader testsReader;
    private final Map<String, SpockParameterMethodVisitor> spockMethodVisitorByMethodName = new HashMap<String, SpockParameterMethodVisitor>();
    private boolean isSpec;

    public SpockParameterClassVisitor(Set<String> set, TestsReader testsReader) {
        this.failedTestNames = set;
        this.testsReader = testsReader;
    }

    @Override
    public Map<String, List<String>> getResult() {
        if (!this.isSpec) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.spockMethodVisitorByMethodName.values().stream().filter(SpockParameterMethodVisitor::isSpockTestMethod).forEach(spockParameterMethodVisitor -> {
            Optional<String> optional = spockParameterMethodVisitor.getUnrollTemplate();
            if (optional.isPresent()) {
                this.addMatchingMethodForFailedTests(hashMap, optional.get(), spockParameterMethodVisitor.getTestMethodName());
            } else {
                this.addMatchingMethodForFailedTests(hashMap, spockParameterMethodVisitor.getTestMethodName(), spockParameterMethodVisitor.getTestMethodName());
            }
        });
        return hashMap;
    }

    private void addMatchingMethodForFailedTests(Map<String, List<String>> map, String string, String string2) {
        String string3 = Arrays.stream(string.split("#[\\p{L}\\d$_.()&&[^#\\s]]+")).map(Pattern::quote).collect(Collectors.joining(".*")) + ".*";
        this.failedTestNames.forEach(string5 -> {
            List list = map.computeIfAbsent((String)string5, string -> new ArrayList());
            if (string.equals(string5) || string5.matches(string3)) {
                list.add(string2);
            }
        });
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        super.visit(n2, n3, string, string2, string3, stringArray);
        if (string3 != null) {
            if (string3.equals("spock/lang/Specification")) {
                this.isSpec = true;
            } else if (!string3.equals("java/lang/Object")) {
                this.testsReader.readClass(string3.replace('/', '.'), () -> this);
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string2, String string3, String string4, String[] stringArray) {
        return this.isSpec ? (MethodVisitor)this.spockMethodVisitorByMethodName.computeIfAbsent(string2, string -> new SpockParameterMethodVisitor()) : null;
    }

    private static final class SpockParameterMethodVisitor
    extends MethodVisitor {
        @Nullable
        private SpockFeatureMetadataAnnotationVisitor featureMethodAnnotationVisitor;
        @Nullable
        private SpockUnrollAnnotationVisitor unrollAnnotationVisitor;

        public SpockParameterMethodVisitor() {
            super(458752);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
            if (string.contains("org/spockframework/runtime/model/FeatureMetadata")) {
                this.featureMethodAnnotationVisitor = new SpockFeatureMetadataAnnotationVisitor();
                return this.featureMethodAnnotationVisitor;
            }
            if (string.contains("spock/lang/Unroll")) {
                this.unrollAnnotationVisitor = new SpockUnrollAnnotationVisitor();
                return this.unrollAnnotationVisitor;
            }
            return null;
        }

        public boolean isSpockTestMethod() {
            return this.featureMethodAnnotationVisitor != null;
        }

        public String getTestMethodName() {
            return Objects.requireNonNull(Objects.requireNonNull(this.featureMethodAnnotationVisitor).testMethodName);
        }

        public Optional<String> getUnrollTemplate() {
            return Optional.ofNullable(this.unrollAnnotationVisitor).map(spockUnrollAnnotationVisitor -> ((SpockUnrollAnnotationVisitor)spockUnrollAnnotationVisitor).unrollTemplate);
        }

        private static final class SpockFeatureMetadataAnnotationVisitor
        extends AnnotationVisitor {
            private String testMethodName;

            public SpockFeatureMetadataAnnotationVisitor() {
                super(458752);
            }

            @Override
            public void visit(String string, Object object) {
                if ("name".equals(string)) {
                    this.testMethodName = (String)object;
                }
            }
        }

        private static final class SpockUnrollAnnotationVisitor
        extends AnnotationVisitor {
            private String unrollTemplate;

            public SpockUnrollAnnotationVisitor() {
                super(458752);
            }

            @Override
            public void visit(String string, Object object) {
                if ("value".equals(string)) {
                    this.unrollTemplate = (String)object;
                }
            }
        }
    }
}

