/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.io;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.StandardLineSeparator;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.function.IOConsumer;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int n2) {
        return new byte[n2];
    }

    public static void checkFromIndexSize(byte[] byArray, int n2, int n3) {
        IOUtils.checkFromIndexSize(n2, n3, Objects.requireNonNull(byArray, "byte array").length);
    }

    static void checkFromIndexSize(int n2, int n3, int n4) {
        if ((n2 | n3 | n4) < 0 || n4 - n3 < n2) {
            throw new IndexOutOfBoundsException(String.format("Range [%s, %<s + %s) out of bounds for length %s", n2, n3, n4));
        }
    }

    public static void close(Closeable closeable, IOConsumer<IOException> iOConsumer) throws IOException {
        block5: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (iOConsumer != null) {
                        iOConsumer.accept(iOException);
                    }
                }
                catch (Exception exception) {
                    if (iOConsumer == null) break block5;
                    iOConsumer.accept(new IOException(exception));
                }
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable, Consumer<Exception> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    if (consumer == null) break block3;
                    consumer.accept(exception);
                }
            }
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(n2));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) throws IOException {
        try (ScratchBytes scratchBytes = ScratchBytes.get();){
            long l4 = IOUtils.copyLarge(inputStream, outputStream, l2, l3, scratchBytes.array());
            return l4;
        }
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) throws IOException {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        IOUtils.checkFromIndexSize(byArray, n2, n3);
        for (n5 = n3; n5 > 0 && -1 != (n6 = inputStream.read(byArray, n2 + (n4 = n3 - n5), n5)); n5 -= n6) {
        }
        return n3 - n5;
    }

    public static long skip(InputStream inputStream, long l2) throws IOException {
        try (ScratchBytes scratchBytes = ScratchBytes.get();){
            long l3 = IOUtils.skip(inputStream, l2, scratchBytes::array);
            return l3;
        }
    }

    public static long skip(InputStream inputStream, long l2, Supplier<byte[]> supplier) throws IOException {
        byte[] byArray;
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(byArray = supplier.get(), 0, (int)Math.min(l3, (long)byArray.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        long l3 = IOUtils.skip(inputStream, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    static final class ScratchBytes
    implements AutoCloseable {
        private static final ThreadLocal<Object[]> LOCAL = ThreadLocal.withInitial(() -> new Object[]{false, IOUtils.byteArray()});
        private static final ScratchBytes INSTANCE = new ScratchBytes(null);
        private final byte[] buffer;

        static ScratchBytes get() {
            Object[] objectArray = LOCAL.get();
            if (((Boolean)objectArray[0]).booleanValue()) {
                return new ScratchBytes(IOUtils.byteArray());
            }
            objectArray[0] = true;
            return INSTANCE;
        }

        private ScratchBytes(byte[] byArray) {
            this.buffer = byArray;
        }

        byte[] array() {
            return this.buffer != null ? this.buffer : (byte[])LOCAL.get()[1];
        }

        @Override
        public void close() {
            if (this.buffer == null) {
                Object[] objectArray = LOCAL.get();
                Arrays.fill((byte[])objectArray[1], (byte)0);
                objectArray[0] = false;
            }
        }
    }
}

