/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.AbstractEventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.DefaultThreadFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FailedFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.OrderedEventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ScheduledFutureTask;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PriorityQueue;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ThrowableUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Async;

public final class GlobalEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalEventExecutor.class);
    private static final long SCHEDULE_QUIET_PERIOD_INTERVAL;
    public static final GlobalEventExecutor INSTANCE;
    final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    final ScheduledFutureTask<Void> quietPeriodTask = new ScheduledFutureTask<Object>((AbstractScheduledEventExecutor)this, Executors.callable(new Runnable(){

        @Override
        public void run() {
        }
    }, null), GlobalEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), SCHEDULE_QUIET_PERIOD_INTERVAL), -SCHEDULE_QUIET_PERIOD_INTERVAL);
    final ThreadFactory threadFactory;
    private final TaskRunner taskRunner = new TaskRunner();
    private final AtomicBoolean started = new AtomicBoolean();
    volatile Thread thread;
    private final Future<?> terminationFuture;

    private GlobalEventExecutor() {
        this.scheduleFromEventLoop(this.quietPeriodTask);
        this.threadFactory = ThreadExecutorMap.apply(new DefaultThreadFactory(DefaultThreadFactory.toPoolName(this.getClass()), false, 5, null), (EventExecutor)this);
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        ThrowableUtil.unknownStackTrace(unsupportedOperationException, GlobalEventExecutor.class, "terminationFuture");
        this.terminationFuture = new FailedFuture(this, unsupportedOperationException);
    }

    Runnable takeTask() {
        Runnable runnable;
        BlockingQueue<Runnable> blockingQueue = this.taskQueue;
        do {
            ScheduledFutureTask<?> scheduledFutureTask;
            if ((scheduledFutureTask = this.peekScheduledTask()) == null) {
                Runnable runnable2 = null;
                try {
                    runnable2 = blockingQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return runnable2;
            }
            long l2 = scheduledFutureTask.delayNanos();
            runnable = null;
            if (l2 > 0L) {
                try {
                    runnable = blockingQueue.poll(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (runnable != null) continue;
            this.fetchFromScheduledTaskQueue();
            runnable = (Runnable)blockingQueue.poll();
        } while (runnable == null);
        return runnable;
    }

    private void fetchFromScheduledTaskQueue() {
        long l2 = this.getCurrentTimeNanos();
        Runnable runnable = this.pollScheduledTask(l2);
        while (runnable != null) {
            this.taskQueue.add(runnable);
            runnable = this.pollScheduledTask(l2);
        }
    }

    private void addTask(Runnable runnable) {
        this.taskQueue.add(ObjectUtil.checkNotNull(runnable, "task"));
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute0(runnable);
    }

    private void execute0(@Async.Schedule Runnable runnable) {
        this.addTask(ObjectUtil.checkNotNull(runnable, "task"));
        if (!this.inEventLoop()) {
            this.startThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        if (this.started.compareAndSet(false, true)) {
            final Thread thread = Thread.currentThread();
            ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return thread.getContextClassLoader();
                }
            });
            GlobalEventExecutor.setContextClassLoader(thread, null);
            try {
                Thread thread2 = this.threadFactory.newThread(this.taskRunner);
                GlobalEventExecutor.setContextClassLoader(thread2, null);
                this.thread = thread2;
                thread2.start();
            }
            finally {
                GlobalEventExecutor.setContextClassLoader(thread, classLoader);
            }
        }
    }

    private static void setContextClassLoader(final Thread thread, final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                thread.setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    static {
        int n2 = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.globalEventExecutor.quietPeriodSeconds", 1);
        if (n2 <= 0) {
            n2 = 1;
        }
        logger.debug("-Dio.netty.globalEventExecutor.quietPeriodSeconds: {}", (Object)n2);
        SCHEDULE_QUIET_PERIOD_INTERVAL = TimeUnit.SECONDS.toNanos(n2);
        INSTANCE = new GlobalEventExecutor();
    }

    final class TaskRunner
    implements Runnable {
        TaskRunner() {
        }

        @Override
        public void run() {
            while (true) {
                Runnable runnable;
                if ((runnable = GlobalEventExecutor.this.takeTask()) != null) {
                    try {
                        AbstractEventExecutor.runTask(runnable);
                    }
                    catch (Throwable throwable) {
                        logger.warn("Unexpected exception from the global event executor: ", throwable);
                    }
                    if (runnable != GlobalEventExecutor.this.quietPeriodTask) continue;
                }
                PriorityQueue priorityQueue = GlobalEventExecutor.this.scheduledTaskQueue;
                if (!GlobalEventExecutor.this.taskQueue.isEmpty() || priorityQueue != null && priorityQueue.size() != 1) continue;
                boolean bl2 = GlobalEventExecutor.this.started.compareAndSet(true, false);
                assert (bl2);
                if (GlobalEventExecutor.this.taskQueue.isEmpty() || !GlobalEventExecutor.this.started.compareAndSet(false, true)) break;
            }
        }
    }
}

