/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel.nio;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoOps;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.NioIoEvent;

public final class NioIoOps
implements IoOps {
    public static final NioIoOps NONE = new NioIoOps(0);
    public static final NioIoOps ACCEPT = new NioIoOps(16);
    public static final NioIoOps CONNECT = new NioIoOps(8);
    public static final NioIoOps WRITE = new NioIoOps(4);
    public static final NioIoOps READ = new NioIoOps(1);
    public static final NioIoOps READ_AND_ACCEPT = new NioIoOps(17);
    public static final NioIoOps READ_AND_WRITE = new NioIoOps(5);
    private static final NioIoEvent[] EVENTS;
    final int value;

    private static void addToArray(NioIoEvent[] nioIoEventArray, NioIoOps nioIoOps) {
        nioIoEventArray[nioIoOps.value] = new DefaultNioIoEvent(nioIoOps);
    }

    private NioIoOps(int n2) {
        this.value = n2;
    }

    public boolean contains(NioIoOps nioIoOps) {
        return this.isIncludedIn(nioIoOps.value);
    }

    public NioIoOps with(NioIoOps nioIoOps) {
        if (this.contains(nioIoOps)) {
            return this;
        }
        return NioIoOps.valueOf(this.value | nioIoOps.value());
    }

    public NioIoOps without(NioIoOps nioIoOps) {
        if (!this.contains(nioIoOps)) {
            return this;
        }
        return NioIoOps.valueOf(this.value & ~nioIoOps.value());
    }

    public int value() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NioIoOps nioIoOps = (NioIoOps)object;
        return this.value == nioIoOps.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static NioIoOps valueOf(int n2) {
        return NioIoOps.eventOf(n2).ops();
    }

    public boolean isIncludedIn(int n2) {
        return (n2 & this.value) != 0;
    }

    static NioIoEvent eventOf(int n2) {
        NioIoEvent nioIoEvent;
        if (n2 > 0 && n2 < EVENTS.length && (nioIoEvent = EVENTS[n2]) != null) {
            return nioIoEvent;
        }
        return new DefaultNioIoEvent(new NioIoOps(n2));
    }

    static {
        NioIoOps nioIoOps = new NioIoOps(NioIoOps.NONE.value | NioIoOps.ACCEPT.value | NioIoOps.CONNECT.value | NioIoOps.WRITE.value | NioIoOps.READ.value);
        EVENTS = new NioIoEvent[nioIoOps.value + 1];
        NioIoOps.addToArray(EVENTS, NONE);
        NioIoOps.addToArray(EVENTS, ACCEPT);
        NioIoOps.addToArray(EVENTS, CONNECT);
        NioIoOps.addToArray(EVENTS, WRITE);
        NioIoOps.addToArray(EVENTS, READ);
        NioIoOps.addToArray(EVENTS, READ_AND_ACCEPT);
        NioIoOps.addToArray(EVENTS, READ_AND_WRITE);
        NioIoOps.addToArray(EVENTS, nioIoOps);
    }

    private static final class DefaultNioIoEvent
    implements NioIoEvent {
        private final NioIoOps ops;

        DefaultNioIoEvent(NioIoOps nioIoOps) {
            this.ops = nioIoOps;
        }

        @Override
        public NioIoOps ops() {
            return this.ops;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NioIoEvent nioIoEvent = (NioIoEvent)object;
            return nioIoEvent.ops().equals(this.ops());
        }

        public int hashCode() {
            return this.ops().hashCode();
        }
    }
}

