/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel.nio;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.AbstractChannel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelException;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ConnectTimeoutException;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.EventLoop;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoEvent;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoEventLoop;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoEventLoopGroup;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoRegistration;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.NioIoEvent;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.NioIoHandle;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.NioIoOps;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    protected final int readInterestOp;
    protected final NioIoOps readOps;
    volatile IoRegistration registration;
    boolean readPending;
    private final Runnable clearReadPendingRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractNioChannel.this.clearReadPending0();
        }
    };
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, int n2) {
        this(channel, selectableChannel, NioIoOps.valueOf(n2));
    }

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, NioIoOps nioIoOps) {
        super(channel);
        this.ch = selectableChannel;
        this.readInterestOp = ObjectUtil.checkNotNull(nioIoOps, (String)"readOps").value;
        this.readOps = nioIoOps;
        try {
            selectableChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            try {
                selectableChannel.close();
            }
            catch (IOException iOException2) {
                logger.warn("Failed to close a partially initialized socket.", iOException2);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    protected void addAndSubmit(NioIoOps nioIoOps) {
        int n2 = this.selectionKey().interestOps();
        if (!nioIoOps.isIncludedIn(n2)) {
            try {
                this.registration().submit(NioIoOps.valueOf(n2).with(nioIoOps));
            }
            catch (Exception exception) {
                throw new ChannelException(exception);
            }
        }
    }

    protected void removeAndSubmit(NioIoOps nioIoOps) {
        int n2 = this.selectionKey().interestOps();
        if (nioIoOps.isIncludedIn(n2)) {
            try {
                this.registration().submit(NioIoOps.valueOf(n2).without(nioIoOps));
            }
            catch (Exception exception) {
                throw new ChannelException(exception);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public NioUnsafe unsafe() {
        return (NioUnsafe)super.unsafe();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    @Deprecated
    protected SelectionKey selectionKey() {
        return (SelectionKey)this.registration().attachment();
    }

    protected IoRegistration registration() {
        assert (this.registration != null);
        return this.registration;
    }

    protected final void clearReadPending() {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.clearReadPending0();
            } else {
                eventLoop.execute(this.clearReadPendingRunnable);
            }
        } else {
            this.readPending = false;
        }
    }

    private void clearReadPending0() {
        this.readPending = false;
        ((AbstractNioUnsafe)this.unsafe()).removeReadOp();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof IoEventLoop && ((IoEventLoopGroup)((Object)eventLoop)).isCompatible(AbstractNioUnsafe.class);
    }

    @Override
    protected void doRegister(ChannelPromise channelPromise) {
        assert (this.registration == null);
        ((IoEventLoop)this.eventLoop()).register((AbstractNioUnsafe)this.unsafe()).addListener(future -> {
            if (future.isSuccess()) {
                this.registration = (IoRegistration)future.getNow();
                channelPromise.setSuccess();
            } else {
                channelPromise.setFailure(future.cause());
            }
        });
    }

    @Override
    protected void doDeregister() throws Exception {
        IoRegistration ioRegistration = this.registration;
        if (ioRegistration != null) {
            this.registration = null;
            ioRegistration.cancel();
        }
    }

    @Override
    protected void doBeginRead() throws Exception {
        IoRegistration ioRegistration = this.registration;
        if (ioRegistration == null || !ioRegistration.isValid()) {
            return;
        }
        this.readPending = true;
        this.addAndSubmit(this.readOps);
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2) throws Exception;

    protected abstract void doFinishConnect() throws Exception;

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.safeRelease(byteBuf);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n2);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf3;
        }
        return byteBuf;
    }

    @Override
    protected void doClose() throws Exception {
        Future<?> future;
        ChannelPromise channelPromise = this.connectPromise;
        if (channelPromise != null) {
            channelPromise.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    protected abstract class AbstractNioUnsafe
    extends AbstractChannel.AbstractUnsafe
    implements NioUnsafe,
    NioIoHandle {
        protected AbstractNioUnsafe() {
        }

        @Override
        public void close() {
            this.close(this.voidPromise());
        }

        @Override
        public SelectableChannel selectableChannel() {
            return this.ch();
        }

        protected final void removeReadOp() {
            IoRegistration ioRegistration = AbstractNioChannel.this.registration();
            if (!ioRegistration.isValid()) {
                return;
            }
            AbstractNioChannel.this.removeAndSubmit(AbstractNioChannel.this.readOps);
        }

        public final SelectableChannel ch() {
            return AbstractNioChannel.this.javaChannel();
        }

        @Override
        public final void connect(final SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (channelPromise.isDone() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                if (AbstractNioChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean bl2 = AbstractNioChannel.this.isActive();
                if (AbstractNioChannel.this.doConnect(socketAddress, socketAddress2)) {
                    this.fulfillConnectPromise(channelPromise, bl2);
                } else {
                    AbstractNioChannel.this.connectPromise = channelPromise;
                    AbstractNioChannel.this.requestedRemoteAddress = socketAddress;
                    final int n2 = AbstractNioChannel.this.config().getConnectTimeoutMillis();
                    if (n2 > 0) {
                        AbstractNioChannel.this.connectTimeoutFuture = (Future)((Object)AbstractNioChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise channelPromise = AbstractNioChannel.this.connectPromise;
                                if (channelPromise != null && !channelPromise.isDone() && channelPromise.tryFailure(new ConnectTimeoutException("connection timed out after " + n2 + " ms: " + socketAddress))) {
                                    AbstractNioUnsafe.this.close(AbstractNioUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)n2, TimeUnit.MILLISECONDS));
                    }
                    channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) {
                            if (channelFuture.isCancelled()) {
                                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractNioChannel.this.connectPromise = null;
                                AbstractNioUnsafe.this.close(AbstractNioUnsafe.this.voidPromise());
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
                this.closeIfClosed();
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl2) {
            if (channelPromise == null) {
                return;
            }
            boolean bl3 = AbstractNioChannel.this.isActive();
            boolean bl4 = channelPromise.trySuccess();
            if (!bl2 && bl3) {
                AbstractNioChannel.this.pipeline().fireChannelActive();
            }
            if (!bl4) {
                this.close(this.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
            if (channelPromise == null) {
                return;
            }
            channelPromise.tryFailure(throwable);
            this.closeIfClosed();
        }

        @Override
        public final void finishConnect() {
            assert (AbstractNioChannel.this.eventLoop().inEventLoop());
            try {
                boolean bl2 = AbstractNioChannel.this.isActive();
                AbstractNioChannel.this.doFinishConnect();
                this.fulfillConnectPromise(AbstractNioChannel.this.connectPromise, bl2);
            }
            catch (Throwable throwable) {
                this.fulfillConnectPromise(AbstractNioChannel.this.connectPromise, this.annotateConnectException(throwable, AbstractNioChannel.this.requestedRemoteAddress));
            }
            finally {
                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractNioChannel.this.connectPromise = null;
            }
        }

        @Override
        protected final void flush0() {
            if (!this.isFlushPending()) {
                super.flush0();
            }
        }

        public final void forceFlush() {
            super.flush0();
        }

        private boolean isFlushPending() {
            IoRegistration ioRegistration = AbstractNioChannel.this.registration();
            return ioRegistration.isValid() && NioIoOps.WRITE.isIncludedIn(((SelectionKey)ioRegistration.attachment()).interestOps());
        }

        @Override
        public void handle(IoRegistration ioRegistration, IoEvent ioEvent) {
            try {
                NioIoEvent nioIoEvent = (NioIoEvent)ioEvent;
                NioIoOps nioIoOps = nioIoEvent.ops();
                if (nioIoOps.contains(NioIoOps.CONNECT)) {
                    AbstractNioChannel.this.removeAndSubmit(NioIoOps.CONNECT);
                    AbstractNioChannel.this.unsafe().finishConnect();
                }
                if (nioIoOps.contains(NioIoOps.WRITE)) {
                    this.forceFlush();
                }
                if (nioIoOps.contains(NioIoOps.READ_AND_ACCEPT) || nioIoOps.equals(NioIoOps.NONE)) {
                    this.read();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.close(this.voidPromise());
            }
        }
    }

    public static interface NioUnsafe
    extends Channel.Unsafe {
        public void finishConnect();

        public void read();
    }
}

