/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.aix;

import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.Uptime;
import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.Who;
import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.perfstat.PerfstatConfig;
import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.perfstat.PerfstatProcess;
import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.AixLibc;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.aix.AixInstalledApps;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.aix.AixOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class AixOperatingSystem
extends AbstractOperatingSystem {
    private final Supplier<Perfstat.perfstat_partition_config_t> config = Memoizer.memoize(PerfstatConfig::queryConfig);
    private final Supplier<Perfstat.perfstat_process_t[]> procCpu = Memoizer.memoize(PerfstatProcess::queryProcesses, Memoizer.defaultExpiration());
    private final Supplier<List<ApplicationInfo>> installedAppsSupplier = Memoizer.memoize(AixInstalledApps::queryInstalledApps, Memoizer.installedAppsExpiration());
    private static final long BOOTTIME = AixOperatingSystem.querySystemBootTimeMillis() / 1000L;

    @Override
    public String queryManufacturer() {
        return "IBM";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String string;
        Perfstat.perfstat_partition_config_t perfstat_partition_config_t2 = this.config.get();
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("os.version");
        if (Util.isBlank(string4)) {
            string4 = ExecutingCommand.getFirstAnswer("oslevel");
        }
        if (Util.isBlank(string = Native.toString(perfstat_partition_config_t2.OSBuild))) {
            string = ExecutingCommand.getFirstAnswer("oslevel -s");
        } else {
            int n2 = string.lastIndexOf(32);
            if (n2 > 0 && n2 < string.length()) {
                string = string.substring(n2 + 1);
            }
        }
        return new Pair<String, OperatingSystem.OSVersionInfo>(string2, new OperatingSystem.OSVersionInfo(string4, string3, string));
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 == 64) {
            return 64;
        }
        return (this.config.get().conf & 0x800000) > 0 ? 64 : 32;
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.getProcessListFromProcfs(-1);
    }

    private List<OSProcess> getProcessListFromProcfs(int n2) {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        Perfstat.perfstat_process_t[] perfstat_process_tArray = this.procCpu.get();
        HashMap<Integer, Pair<Long, Long>> hashMap = new HashMap<Integer, Pair<Long, Long>>();
        for (Perfstat.perfstat_process_t perfstat_process_t2 : perfstat_process_tArray) {
            int n3 = (int)perfstat_process_t2.pid;
            if (n2 >= 0 && n3 != n2) continue;
            hashMap.put(n3, new Pair<Long, Long>((long)perfstat_process_t2.ucpu_time, (long)perfstat_process_t2.scpu_time));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            AixOSProcess aixOSProcess = new AixOSProcess((Integer)entry.getKey(), (Pair)entry.getValue(), this.procCpu, this);
            if (aixOSProcess.getState() == OSProcess.State.INVALID) continue;
            arrayList.add(aixOSProcess);
        }
        return arrayList;
    }

    @Override
    public int getProcessId() {
        return AixLibc.INSTANCE.getpid();
    }

    private static long querySystemBootTimeMillis() {
        long l2 = Who.queryBootTime();
        if (l2 >= 1000L) {
            return l2;
        }
        return System.currentTimeMillis() - Uptime.queryUpTime();
    }
}

