/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.linux.proc;

import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.util.Constants;
import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.linux.ProcPath;
import java.io.File;
import java.util.regex.Pattern;

public final class ProcessStat {
    private static final Pattern SOCKET = Pattern.compile("socket:\\[(\\d+)\\]");
    public static final int PROC_PID_STAT_LENGTH;

    public static File[] getPidFiles() {
        return ProcessStat.listNumericFiles(ProcPath.PROC);
    }

    private static File[] listNumericFiles(String string) {
        File file2 = new File(string);
        File[] fileArray = file2.listFiles(file -> Constants.DIGITS.matcher(file.getName()).matches());
        return fileArray == null ? new File[]{} : fileArray;
    }

    public static OSProcess.State getState(char c2) {
        OSProcess.State state;
        switch (c2) {
            case 'R': {
                state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': {
                state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                state = OSProcess.State.OTHER;
            }
        }
        return state;
    }

    static {
        String string = FileUtil.getStringFromFile(ProcPath.SELF_STAT);
        PROC_PID_STAT_LENGTH = string.contains(")") ? ParseUtil.countStringToLongArray(string, ' ') + 3 : 52;
    }
}

